/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.utils.StringUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileNaturalistChest
extends TileBase
implements IInventory {
    private ItemStack[] inventoryStacks = new ItemStack[125];
    private final ISpeciesRoot speciesRoot;
    private final int guiID;

    public TileNaturalistChest(ISpeciesRoot speciesRoot, int guiId) {
        this.setHints((String[])Config.hints.get("apiarist.chest"));
        this.speciesRoot = speciesRoot;
        this.guiID = guiId;
    }

    @Override
    public String func_70303_b() {
        return StringUtil.localize("tile.mill.3");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, this.guiID, player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventoryStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        this.inventoryStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return this.speciesRoot.isMember(itemstack);
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].field_77994_a <= j) {
            ItemStack product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        ItemStack product = this.inventoryStacks[i].func_77979_a(j);
        if (this.inventoryStacks[i].field_77994_a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

