/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleHandler;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILegacyHandler;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Classification;
import forestry.core.utils.IDAllocator;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AlleleRegistry
implements IAlleleRegistry,
ILegacyHandler {
    public static final int ALLELE_ARRAY_SIZE = 2048;
    private LinkedHashMap rootMap = new LinkedHashMap(16);
    private LinkedHashMap alleleMap = new LinkedHashMap(2048);
    private LinkedHashMap classificationMap = new LinkedHashMap(128);
    private LinkedHashMap fruitMap = new LinkedHashMap(64);
    private HashMap metaMapToUID = new HashMap();
    private HashMap uidMapToMeta = new HashMap();
    private HashMap legacyMap = new HashMap();
    private HashSet alleleHandlers = new HashSet();
    private ArrayList blacklist = new ArrayList();

    @Override
    public void registerSpeciesRoot(ISpeciesRoot root) {
        this.rootMap.put(root.getUID(), root);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(String uid) {
        if (this.rootMap.containsKey(uid)) {
            return (ISpeciesRoot)this.rootMap.get(uid);
        }
        return null;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        for (ISpeciesRoot root : this.rootMap.values()) {
            if (!root.isMember(stack)) continue;
            return root;
        }
        return null;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(Class clz) {
        for (ISpeciesRoot root : this.rootMap.values()) {
            if (!root.getMemberClass().isAssignableFrom(clz)) continue;
            return root;
        }
        return null;
    }

    @Override
    public boolean isIndividual(ItemStack stack) {
        if (PluginApiculture.beeInterface != null && PluginApiculture.beeInterface.isMember(stack)) {
            return true;
        }
        return PluginArboriculture.treeInterface != null && PluginArboriculture.treeInterface.isMember(stack);
    }

    @Override
    public IIndividual getIndividual(ItemStack stack) {
        ISpeciesRoot root = this.getSpeciesRoot(stack);
        if (root == null) {
            return null;
        }
        return root.getMember(stack);
    }

    public void initialize() {
        this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "archaea", "Archaea");
        this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "bacteria", "Bacteria");
        IClassification eukarya = this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "eukarya", "Eukarya");
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "animalia", "Animalia"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "plantae", "Plantae"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "fungi", "Fungi"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "protista", "Protista"));
        this.getClassification("kingdom.animalia").addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.PHYLUM, "arthropoda", "Arthropoda"));
        this.getClassification("phylum.arthropoda").addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "insecta", "Insecta"));
    }

    @Override
    public LinkedHashMap getRegisteredAlleles() {
        return this.alleleMap;
    }

    @Override
    public LinkedHashMap getRegisteredClassifications() {
        return this.classificationMap;
    }

    @Override
    public LinkedHashMap getRegisteredFruitFamilies() {
        return this.fruitMap;
    }

    @Override
    public void registerAllele(IAllele allele) {
        IClassification branch;
        this.alleleMap.put(allele.getUID(), allele);
        if (allele instanceof IAlleleSpecies && (branch = ((IAlleleSpecies)allele).getBranch()) != null) {
            branch.addMemberSpecies((IAlleleSpecies)allele);
        }
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterAllele(allele);
        }
    }

    @Override
    public IAllele getAllele(String uid) {
        return (IAllele)this.alleleMap.get(uid);
    }

    @Override
    public void reloadMetaMap(World world) {
        this.metaMapToUID.clear();
        this.uidMapToMeta.clear();
        for (Map.Entry entry : this.alleleMap.entrySet()) {
            if (!(entry.getValue() instanceof IAlleleSpecies)) continue;
            int meta = IDAllocator.getIDAllocator(world, "speciesMetaMap").getId((String)entry.getKey());
            this.metaMapToUID.put(meta, entry.getKey());
            this.uidMapToMeta.put(entry.getKey(), meta);
        }
    }

    @Override
    public IAllele getFromMetaMap(int meta) {
        if (!this.metaMapToUID.containsKey(meta)) {
            return null;
        }
        return this.getAllele((String)this.metaMapToUID.get(meta));
    }

    @Override
    public int getFromUIDMap(String uid) {
        if (!this.uidMapToMeta.containsKey(uid)) {
            return 0;
        }
        return (Integer)this.uidMapToMeta.get(uid);
    }

    @Override
    public void registerClassification(IClassification branch) {
        if (this.classificationMap.containsKey(branch.getUID())) {
            throw new RuntimeException(String.format("Could not add new classification '%s', because the key is already taken by %s.", branch.getUID(), this.classificationMap.get(branch.getUID())));
        }
        this.classificationMap.put(branch.getUID(), branch);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterClassification(branch);
        }
    }

    @Override
    public IClassification createAndRegisterClassification(IClassification.EnumClassLevel level, String uid, String scientific) {
        return new Classification(level, uid, scientific);
    }

    @Override
    public IClassification getClassification(String uid) {
        return (IClassification)this.classificationMap.get(uid);
    }

    @Override
    public void registerFruitFamily(IFruitFamily family) {
        this.fruitMap.put(family.getUID(), family);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterFruitFamily(family);
        }
    }

    @Override
    public IFruitFamily getFruitFamily(String uid) {
        return (IFruitFamily)this.fruitMap.get(uid);
    }

    @Override
    public void registerLegacyMapping(int id, String uid) {
        this.legacyMap.put(id, uid);
    }

    @Override
    public IAllele getFromLegacyMap(int id) {
        if (!this.legacyMap.containsKey(id)) {
            return null;
        }
        return this.getAllele((String)this.legacyMap.get(id));
    }

    @Override
    public void registerAlleleHandler(IAlleleHandler handler) {
        this.alleleHandlers.add(handler);
    }

    @Override
    public void blacklistAllele(String uid) {
        this.blacklist.add(uid);
    }

    @Override
    public ArrayList getAlleleBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean isBlacklisted(String uid) {
        return this.blacklist.contains(uid);
    }
}

