/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GfxSlot;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumRarity;
import org.lwjgl.opengl.GL11;

public class GfxSlotManager {
    public GuiForestry gui;
    public Minecraft minecraft;
    protected ArrayList slots = new ArrayList();

    public GfxSlotManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(GfxSlot slot) {
        this.slots.add(slot);
    }

    public void remove(GfxSlot slot) {
        this.slots.remove(slot);
    }

    public void clear() {
        this.slots.clear();
    }

    protected GfxSlot getAtPosition(int mX, int mY) {
        for (GfxSlot slot : this.slots) {
            if (!slot.intersectsWith(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void drawSlots() {
        for (GfxSlot slot : this.slots) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            slot.draw(0, 0);
        }
    }

    public void drawTooltips(int mouseX, int mouseY) {
        GfxSlot slot = this.getAtPosition(mouseX - this.gui.guiLeft, mouseY - this.gui.guiTop);
        if (slot != null) {
            this.gui.drawTooltip(mouseX, mouseY, 300.0f, slot.getItemNameandInformation(), EnumRarity.common);
        }
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        GfxSlot slot = this.getAtPosition(mouseX - this.gui.guiLeft, mouseY - this.gui.guiTop);
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }
}

