/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiAlyzer
extends GuiForestry {
    protected static final int COLUMN_0 = 12;
    protected static final int COLUMN_1 = 52;
    protected static final int COLUMN_2 = 108;
    protected IInventory inventory;
    protected ISpeciesRoot speciesRoot;
    protected IBreedingTracker breedingTracker;
    protected HashMap iconStacks = new HashMap();

    public GuiAlyzer(ISpeciesRoot speciesRoot, EntityPlayer player, ContainerForestry container, IInventory inventory, int pageMax, int pageSize) {
        super("/gfx/forestry/gui/beealyzer.png", container);
        this.inventory = inventory;
        this.speciesRoot = speciesRoot;
        this.breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.field_71092_bJ);
    }

    protected final int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    protected final void drawLine(String text, int x, IIndividual individual, Enum chromosome, boolean inactive) {
        if (!inactive) {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()));
        } else {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
        }
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, Enum chromosome, boolean inactive) {
        if (!inactive) {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()));
        } else {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
        }
    }

    protected final void drawRow(String text0, String text1, String text2, IIndividual individual, Enum chromosome) {
        this.drawRow(text0, text1, text2, this.fontColor.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
    }

    protected final void drawSpeciesRow(String text0, IIndividual individual, Enum chromosome) {
        IAlleleSpecies primary = individual.getGenome().getPrimary();
        IAlleleSpecies secondary = individual.getGenome().getSecondary();
        this.drawLine(text0, this.column0);
        int columnwidth = this.column2 - this.column1 - 16;
        itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(primary.getUID()), this.adjustToFactor(this.guiLeft + this.column1 + columnwidth + 2), this.adjustToFactor(this.guiTop + this.getLineY()));
        itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(secondary.getUID()), this.adjustToFactor(this.guiLeft + this.column2 + columnwidth + 4), this.adjustToFactor(this.guiTop + this.getLineY()));
        RenderHelper.func_74518_a();
        this.drawSplitLine(primary.getName(), this.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(secondary.getName(), this.column2, columnwidth, individual, chromosome, true);
        this.newLine();
        this.newLine();
    }

    protected final void drawAnalyticsPageClassification(IIndividual individual) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.alyzer.classification") + ":", 12);
        this.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific() == null || classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.drawLine(group.getScientific(), x, group.getLevel().getColour());
            this.drawLine(group.getLevel().name(), 130, group.getLevel().getColour());
            this.newLine();
            x += 8;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.drawLine(binomial, x, 15445637);
        this.drawLine("SPECIES", 130, 15445637);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleManager.alleleRegistry.isBlacklisted(individual.getIdent())) {
            String extinct = ">> " + StringUtil.localize("gui.alyzer.extinct").toUpperCase() + " <<";
            this.field_73886_k.func_78261_a(extinct, this.adjustToFactor(this.guiLeft + 160) - this.field_73886_k.func_78256_a(extinct), this.adjustToFactor(this.guiTop + this.getLineY()), this.fontColor.get("gui.beealyzer.dominant"));
        }
        this.newLine();
        String description = individual.getGenome().getPrimary().getDescription();
        if (description == null || description.isEmpty()) {
            this.drawSplitLine(StringUtil.localize("gui.alyzer.nodescription"), 12, 156, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.drawSplitLine(tokens[0], 12, 152, 0x666666);
            if (tokens.length > 1) {
                this.field_73886_k.func_78261_a("- " + tokens[1], this.adjustToFactor(this.guiLeft + 160) - this.field_73886_k.func_78256_a("- " + tokens[1]), this.adjustToFactor(this.guiTop + 145 - 14), 10079282);
            }
        }
        this.endPage();
    }

    protected void drawAnalyticsPage4(IIndividual individual) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.beealyzer.mutations") + ":", 12);
        this.newLine();
        this.newLine();
        RenderHelper.func_74520_c();
        HashMap<IMutation, IAlleleSpecies> combinations = new HashMap<IMutation, IAlleleSpecies>();
        for (IMutation mutation : this.speciesRoot.getCombinations(individual.getGenome().getPrimary())) {
            combinations.put(mutation, individual.getGenome().getPrimary());
        }
        for (IMutation mutation : this.speciesRoot.getCombinations(individual.getGenome().getSecondary())) {
            combinations.put(mutation, individual.getGenome().getSecondary());
        }
        int columnWidth = 50;
        int x = 0;
        for (Map.Entry mutation : combinations.entrySet()) {
            if (this.breedingTracker.isDiscovered((IMutation)mutation.getKey())) {
                this.drawMutationInfo((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + x);
            } else {
                if (((IMutation)mutation.getKey()).isSecret()) continue;
                this.drawUnknownMutation((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + x);
            }
            if ((x += columnWidth) <= 150) continue;
            x = 0;
            this.newLine();
            this.newLine();
        }
        this.endPage();
    }

    protected void drawMutationInfo(IMutation combination, IAllele species, int x) {
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY());
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY());
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(result.getUID()), this.adjustToFactor(this.guiLeft) + x + 33, this.adjustToFactor(this.guiTop) + this.getLineY());
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(result.getUID()), this.adjustToFactor(this.guiLeft) + x + 33, this.adjustToFactor(this.guiTop) + this.getLineY());
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 18, this.adjustToFactor(this.guiTop) + this.getLineY() + 4, column, line, 15, 9);
    }

    protected void drawUnknownMutation(IMutation combination, IAllele species, int x) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY(), 196, 18, 16, 16);
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 32, this.adjustToFactor(this.guiTop) + this.getLineY(), 196, 18, 16, 16);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 18, this.adjustToFactor(this.guiTop) + this.getLineY() + 4, column, line, 15, 9);
    }

    protected void drawToleranceInfo(EnumTolerance tolerance, int x, int textColor) {
        int length = tolerance.toString().length();
        String text = "(" + tolerance.toString().substring(length - 1) + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x, this.getLineY() - 1);
                this.drawLine("(0)", x + 15, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 196, 34, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 211, 34, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 226, 34, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 241, 34, 15, 9);
    }

    protected void drawFertilityInfo(int fertility, int x, int textColor, int texOffset) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x + 19) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 196, 43 + texOffset, 12, 9);
        this.drawLine(Integer.toString(fertility) + " x", x, textColor);
    }
}

