/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiNaturalistInventory
extends GuiForestry {
    private IInventory inventory;
    private ISpeciesRoot speciesRoot;
    private IBreedingTracker breedingTracker;
    private HashMap iconStacks = new HashMap();

    public GuiNaturalistInventory(ISpeciesRoot speciesRoot, EntityPlayer player, ContainerForestry container, IInventory inventory) {
        super("/gfx/forestry/gui/apiaristinventory.png", container, inventory, 5, 25);
        this.inventory = inventory;
        this.speciesRoot = speciesRoot;
        this.xSize = 196;
        this.ySize = 202;
        for (IIndividual individual : speciesRoot.getIndividualTemplates()) {
            this.iconStacks.put(individual.getIdent(), speciesRoot.getMemberStack(individual, 0));
        }
        this.breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.field_71092_bJ);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(this.textureFile);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.field_73886_k.func_78276_b(header, this.guiLeft + 95 + this.getCenteredOffset(header, 98), this.guiTop + 10, this.fontColor.get("gui.title"));
        IIndividual individual = this.getIndividualAtPosition(i, j);
        if (individual == null) {
            this.displayBreedingStatistics(10);
        }
        if (individual != null) {
            RenderHelper.func_74520_c();
            this.startPage();
            this.displaySpeciesInformation(true, individual.getGenome().getPrimary(), (ItemStack)this.iconStacks.get(individual.getIdent()), 10);
            if (!individual.isPureBred(0)) {
                this.displaySpeciesInformation(individual.isAnalyzed(), individual.getGenome().getSecondary(), (ItemStack)this.iconStacks.get(individual.getGenome().getSecondary().getUID()), 10);
            }
            this.endPage();
        }
    }

    @Override
    public void func_73874_b() {
        super.func_73874_b();
        if (this.field_73882_e.field_71439_g == null) {
            return;
        }
        if (this.inventorySlots instanceof ContainerItemInventory) {
            ((ContainerItemInventory)this.inventorySlots).purgeBag((EntityPlayer)this.field_73882_e.field_71439_g);
        }
        if (!Proxies.common.isSimulating(Proxies.common.getRenderWorld())) {
            return;
        }
        if (this.inventory instanceof ItemInventory) {
            ItemInventory inv = (ItemInventory)this.inventory;
            if (inv.isItemInventory) {
                inv.onGuiSaved((EntityPlayer)this.field_73882_e.field_71439_g);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.add(new GuiButton(1, this.guiLeft + 99, this.guiTop + 7, 10, 12, "<"));
        this.field_73887_h.add(new GuiButton(2, this.guiLeft + 179, this.guiTop + 7, 10, 12, ">"));
    }

    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        if (guibutton.field_73741_f == 1 && this.pageCurrent > 0) {
            this.flipPage(this.pageCurrent - 1);
        } else if (guibutton.field_73741_f == 2 && this.pageCurrent < this.pageMax - 1) {
            this.flipPage(this.pageCurrent + 1);
        }
    }

    private IIndividual getIndividualAtPosition(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        if (slot == null) {
            return null;
        }
        if (!slot.func_75216_d()) {
            return null;
        }
        if (!slot.func_75211_c().func_77942_o()) {
            return null;
        }
        if (!this.speciesRoot.isMember(slot.func_75211_c())) {
            return null;
        }
        return this.speciesRoot.getMember(slot.func_75211_c());
    }

    private void displayBreedingStatistics(int x) {
        this.startPage();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + this.speciesRoot.getSpeciesCount(), x);
        this.newLine();
        this.newLine();
        if (this.breedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)this.breedingTracker;
            this.drawLine(StringUtil.localize("gui.queens") + ": " + tracker.getQueenCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.princesses") + ": " + tracker.getPrincessCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.drones") + ": " + tracker.getDroneCount(), x);
            this.newLine();
        }
        this.endPage();
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleSpecies species, ItemStack iconStack, int x) {
        if (!analyzed) {
            this.drawLine(StringUtil.localize("gui.unknown"), x);
            return;
        }
        this.drawLine(species.getName(), x);
        itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, iconStack, this.adjustToFactor(this.guiLeft + x + 69), this.adjustToFactor(this.guiTop + this.getLineY() - 2));
        this.newLine();
        int columnWidth = 16;
        int column = 10;
        for (IMutation combination : this.speciesRoot.getCombinations(species)) {
            if (combination.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column);
            } else {
                this.drawUnknownIcon(combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.newLine(18);
        }
        this.newLine();
        this.newLine();
    }

    private void drawMutationIcon(IMutation combination, IAlleleSpecies species, int x) {
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()));
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()));
        int line = 48;
        int column = 0;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/apiaristinventory.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()), column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x) {
        float chance = mutation.getBaseChance();
        int line = 0;
        int column = 0;
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/apiaristinventory.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()), column, line, 16, 16);
    }
}

