/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import buildcraft.api.tools.IToolPipette;
import forestry.core.config.Config;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.GfxSlot;
import forestry.core.gui.GfxSlotManager;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LiquidTankSlot
extends GfxSlot {
    protected int overlayTexX = 176;
    protected int overlayTexY = 0;
    protected ILiquidTank tank;
    protected int slot = 0;

    public LiquidTankSlot(GfxSlotManager manager, int xPos, int yPos, ILiquidTankContainer tile, int slot) {
        this(manager, xPos, yPos, tile.getTanks(ForgeDirection.UNKNOWN)[slot], slot);
    }

    public LiquidTankSlot(GfxSlotManager manager, int xPos, int yPos, ILiquidTank tank, int slot) {
        super(manager, xPos, yPos);
        this.tank = tank;
        this.slot = slot;
        this.height = 58;
    }

    public LiquidTankSlot setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    @Override
    public void draw(int startX, int startY) {
        int x;
        if (this.tank == null) {
            return;
        }
        Icon liquidIcon = null;
        int liquidId = this.tank.getLiquid().itemID;
        int liquidMeta = this.tank.getLiquid().itemMeta;
        int squaled = this.tank.getLiquid().amount * this.height / this.tank.getCapacity();
        String texture = "/terrain.png";
        if (liquidId <= 0) {
            return;
        }
        if (liquidId < Block.field_71973_m.length && Block.field_71973_m[liquidId].field_71990_ca > 0) {
            liquidIcon = Block.field_71973_m[liquidId].func_71851_a(0);
        } else {
            liquidIcon = Item.field_77698_e[liquidId].func_77617_a(liquidMeta);
            texture = "/gui/items.png";
        }
        this.manager.minecraft.field_71446_o.func_98187_b(texture);
        int start = 0;
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        this.manager.minecraft.field_71446_o.func_98187_b(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
        GL11.glEnable((int)2896);
    }

    @Override
    public String getTooltip(EntityPlayer player) {
        LiquidStack liquidStack = this.tank.getLiquid();
        if (liquidStack != null && liquidStack.itemID > 0) {
            String tooltip = Item.field_77698_e[liquidStack.itemID].func_77628_j(liquidStack.asItemStack());
            if (Config.tooltipLiquidAmount) {
                tooltip = tooltip + " (" + this.tank.getLiquid().amount + ")";
            }
            return tooltip;
        }
        return StringUtil.localize("gui.empty");
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (held instanceof IToolPipette && this.manager.gui.inventorySlots instanceof ContainerLiquidTanks) {
            ((ContainerLiquidTanks)this.manager.gui.inventorySlots).handlePipetteClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g);
        }
    }
}

