/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class ItemLiquidContainer
extends Item {
    private boolean isDrink = false;
    private boolean isAlwaysEdible = false;
    private int healAmount = 0;
    private float saturationModifier = 0.0f;
    private EnumContainerType type;
    private int colour;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemLiquidContainer(int i, EnumContainerType type, int colour) {
        super(i);
        this.type = type;
        this.colour = colour;
        this.func_77637_a(CreativeTabForestry.tabForestry);
        this.func_77625_d(16);
    }

    private int getMatchingSlot(EntityPlayer player, ItemStack stack) {
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            int space;
            ItemStack slotStack = player.field_71071_by.func_70301_a(slot);
            if (slotStack == null) {
                return slot;
            }
            if (!slotStack.func_77969_a(stack) || (space = slotStack.func_77976_d() - slotStack.field_77994_a) < stack.field_77994_a) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!this.isDrink) {
            return itemstack;
        }
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_75122_a(this.getHealAmount(), this.getSaturationModifier());
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        if (this.isDrink) {
            return 32;
        }
        return super.func_77626_a(itemstack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.isDrink) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (this.isDrink) {
            if (entityplayer.func_71043_e(this.isAlwaysEdible)) {
                entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
            }
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityplayer, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            int targetedMeta;
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            int targetedId = world.func_72798_a(i, j, k);
            LiquidContainerData container = LiquidHelper.getEmptyContainer(itemstack, new LiquidStack(targetedId, 1, targetedMeta = world.func_72805_g(i, j, k)));
            if (container == null) {
                return itemstack;
            }
            int slot = this.getMatchingSlot(entityplayer, container.filled);
            if (slot < 0) {
                return itemstack;
            }
            if (entityplayer.field_71071_by.func_70301_a(slot) == null) {
                entityplayer.field_71071_by.func_70299_a(slot, container.filled.func_77946_l());
            } else {
                ++entityplayer.field_71071_by.func_70301_a((int)slot).field_77994_a;
            }
            world.func_72832_d(i, j, k, 0, 0, 3);
            --itemstack.field_77994_a;
            Proxies.net.inventoryChangeNotify(entityplayer);
            return itemstack;
        }
        return itemstack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public ItemLiquidContainer setDrink(int healAmount, float saturationModifier) {
        this.isDrink = true;
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
        return this;
    }

    public ItemLiquidContainer setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    public String func_77628_j(ItemStack itemstack) {
        return StringUtil.localize(this.func_77667_c(itemstack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons = new Icon[2];
        this.icons[0] = TextureManager.getInstance().registerItemTex("liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".bottle");
        this.icons[1] = TextureManager.getInstance().registerItemTex("liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".contents");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        if (j > 0 && this.colour >= 0) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j > 0 && this.colour >= 0) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    public static enum EnumContainerType {
        GLASS,
        JAR,
        CAN,
        CAPSULE,
        REFRACTORY;

    }
}

