/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import forestry.apiculture.render.TextureBiomefinder;
import forestry.core.ForestryClient;
import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyCommon;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.texturepacks.ITexturePack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StringTranslate;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ClientProxyCommon
extends ProxyCommon {
    @Override
    public void bindTexture(String textureFile) {
        this.getClientInstance().field_71446_o.func_98187_b(textureFile);
    }

    @Override
    public ITexturePack getSelectedTexturePack(Minecraft minecraft) {
        return minecraft.field_71418_C.func_77292_e();
    }

    @Override
    public void setBiomefinderCoordinates(EntityPlayer player, ChunkCoordinates coordinates) {
        if (this.isSimulating(player.field_70170_p)) {
            super.setBiomefinderCoordinates(player, coordinates);
        } else {
            TextureBiomefinder.getInstance().setTargetCoordinates(coordinates);
        }
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.func_71380_b();
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().field_71441_e;
    }

    @Override
    public int getBlockModelIdEngine() {
        return ForestryClient.blockModelIdEngine;
    }

    @Override
    public int getByBlockModelId() {
        return ForestryClient.byBlockModelId;
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return true;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().field_71442_b.func_78757_d();
        }
        return 4.0;
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getItemDisplayName(Item item) {
        return Item.field_77698_e[item.field_77779_bT].func_77628_j(null);
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.func_77973_b().func_77628_j(stack);
    }

    @Override
    public String getCurrentLanguage() {
        return StringTranslate.func_74808_a().func_74811_c();
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.func_77973_b().func_77628_j(itemstack);
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_72020_cn.func_82593_b(), block.field_72020_cn.func_72677_b(), block.field_72020_cn.func_72678_c());
        }
    }

    @Override
    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_72020_cn.func_72676_a(), block.field_72020_cn.func_72677_b() / 4.0f, block.field_72020_cn.func_72678_c());
        }
    }

    @Override
    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_72020_cn.func_82593_b(), block.field_72020_cn.func_72677_b() / 4.0f, block.field_72020_cn.func_72678_c());
        }
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
        world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, volume, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    @Override
    public void addEntityBiodustFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!Config.enableParticleFX) {
            return;
        }
    }

    @Override
    public void addEntitySwarmFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!Config.enableParticleFX) {
            return;
        }
    }

    @Override
    public void addEntityExplodeFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!Config.enableParticleFX) {
            return;
        }
        this.getClientInstance().field_71452_i.func_78873_a((EntityFX)new EntityExplodeFX(world, d1, d2, d3, (double)f1, (double)f2, (double)f3));
    }

    @Override
    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, int blockid, int i) {
        if (!this.isSimulating(world)) {
            this.getClientInstance().field_71452_i.func_78871_a(xCoord, yCoord, zCoord, blockid, i);
        } else {
            super.addBlockDestroyEffects(world, xCoord, yCoord, zCoord, blockid, i);
        }
    }

    @Override
    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, int blockid, int i) {
        if (!this.isSimulating(world)) {
            this.playBlockPlaceSoundFX(world, xCoord, yCoord, zCoord, Block.field_71973_m[blockid]);
        } else {
            super.addBlockPlaceEffects(world, xCoord, yCoord, zCoord, blockid, i);
        }
    }
}

