/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gadgets.TileForestry;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtils {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.field_77993_c != rhs.field_77993_c) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.func_70302_i_());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
                itemstack.field_77994_a -= space;
            }
            added = true;
        }
        return added;
    }

    public static int addToInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        int added = 0;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                }
                return itemstack.field_77994_a;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a - added) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                }
                return itemstack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        return added;
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.field_77994_a >= 64) {
            return;
        }
        if (!receptor.func_77969_a(giver)) {
            return;
        }
        if (giver.field_77994_a <= receptor.func_77976_d() - receptor.field_77994_a) {
            receptor.field_77994_a += giver.field_77994_a;
            giver.field_77994_a = 0;
            return;
        }
        ItemStack temp = giver.func_77979_a(receptor.func_77976_d() - receptor.field_77994_a);
        receptor.field_77994_a += temp.field_77994_a;
        temp.field_77994_a = 0;
    }

    public static boolean freeSpaceInStack(ItemStack stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.field_77994_a < maxSize;
    }

    public static boolean canAddToStack(ItemStack stack, ItemStack inventory) {
        if (inventory == null) {
            return true;
        }
        return stack.field_77993_c == inventory.field_77993_c;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.field_77993_c, amount, stack.func_77960_j());
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.func_77978_p().func_74737_b();
            split.func_77982_d(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack)) continue;
                cached.field_77994_a += stack.field_77994_a;
                matched = true;
            }
            if (matched) continue;
            condensed.add(stack.func_77946_l());
        }
        return condensed.toArray(EMPTY_STACK_ARRAY);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return StackUtils.containsSets(set, stock, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, boolean oreDictionary) {
        int count = 0;
        ItemStack[] condensedRequired = StackUtils.condenseStacks(set);
        ItemStack[] condensedOffered = StackUtils.condenseStacks(stock);
        for (ItemStack req : condensedRequired) {
            boolean matched = false;
            for (ItemStack offer : condensedOffered) {
                boolean isEqual = false;
                isEqual = oreDictionary ? StackUtils.isItemOreEqual(req, offer) : req.func_77969_a(offer);
                if (!isEqual) continue;
                matched = true;
                int stackCount = (int)Math.floor(offer.field_77994_a / req.field_77994_a);
                if (stackCount <= 0) {
                    return 0;
                }
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isItemOreEqual(ItemStack base, ItemStack comparison) {
        if (base.func_77969_a(comparison)) {
            return true;
        }
        ArrayList copperIngots = OreDictionary.getOres((String)"ingotCopper");
        for (ItemStack ore : copperIngots) {
            if (!ore.func_77969_a(base)) continue;
            for (ItemStack ore1 : copperIngots) {
                if (!ore1.func_77969_a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList tinIngots = OreDictionary.getOres((String)"ingotTin");
        for (ItemStack ore : tinIngots) {
            if (!ore.func_77969_a(base)) continue;
            for (ItemStack ore1 : tinIngots) {
                if (!ore1.func_77969_a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList bronzeIngots = OreDictionary.getOres((String)"ingotBronze");
        for (ItemStack ore : bronzeIngots) {
            if (!ore.func_77969_a(base)) continue;
            for (ItemStack ore1 : bronzeIngots) {
                if (!ore1.func_77969_a(comparison)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        if (items.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.field_70293_c = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static void replenishByContainer(TileForestry tile, ItemStack inventoryStack, TankSlot tank) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(inventoryStack);
        StackUtils.replenishByContainer(tile, inventoryStack, container, tank);
    }

    public static ItemStack replenishByContainer(TileForestry tile, ItemStack inventoryStack, LiquidContainerData container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.stillLiquid, false) >= container.stillLiquid.amount) {
            tank.fill(container.stillLiquid, true);
            if (container.filled != null && container.filled.func_77973_b().func_77634_r()) {
                inventoryStack = container.container.func_77946_l();
            } else {
                --inventoryStack.field_77994_a;
            }
            tile.sendNetworkUpdate();
        }
        return inventoryStack;
    }
}

