/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.network.EntityNetData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class TankSlot
implements ILiquidTank {
    public static TankSlot FAKETANK = new TankSlot(0);
    public static TankSlot[] FAKETANK_ARRAY = new TankSlot[]{FAKETANK};
    @EntityNetData
    public int capacity = 0;
    @EntityNetData
    public int liquidId = 0;
    @EntityNetData
    public int liquidMeta = 0;
    @EntityNetData
    public int quantity = 0;

    public TankSlot(int capacity) {
        this.capacity = capacity;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("liquidId", this.liquidId);
        nbttagcompound.func_74768_a("liquidMeta", this.liquidMeta);
        nbttagcompound.func_74768_a("quantity", this.quantity);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.liquidId = nbttagcompound.func_74762_e("liquidId");
        this.liquidMeta = nbttagcompound.func_74762_e("liquidMeta");
        this.quantity = this.liquidId != 0 ? nbttagcompound.func_74762_e("quantity") : 0;
    }

    public LiquidStack asLiquidStack() {
        return new LiquidStack(this.liquidId, this.quantity, this.liquidMeta);
    }

    public LiquidStack getLiquid() {
        return this.asLiquidStack();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        int filled = 0;
        if (this.quantity != 0 && (this.liquidId != resource.itemID || this.liquidMeta != resource.itemMeta)) {
            filled = 0;
        } else if (this.quantity + resource.amount <= this.capacity) {
            if (doFill) {
                this.quantity += resource.amount;
            }
            this.liquidId = resource.itemID;
            this.liquidMeta = resource.itemMeta;
            filled = resource.amount;
        } else {
            int used = this.capacity - this.quantity;
            if (doFill) {
                this.quantity = this.capacity;
            }
            this.liquidId = resource.itemID;
            this.liquidMeta = resource.itemMeta;
            filled = used;
        }
        return filled;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        int used = maxDrain;
        if (this.quantity < maxDrain) {
            used = this.quantity;
        }
        LiquidStack product = new LiquidStack(this.liquidId, used, this.liquidMeta);
        if (doDrain) {
            this.quantity -= used;
            if (this.quantity <= 0 && this.liquidId > 0) {
                this.liquidId = 0;
                this.liquidMeta = 0;
            }
        }
        return product;
    }

    public int getTankPressure() {
        return 0;
    }
}

