/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.energy.gadgets.EngineTin;
import net.minecraft.tileentity.TileEntity;

public abstract class CircuitElectricChange
extends Circuit {
    int euChange = 7;
    int mjChange = 2;

    public CircuitElectricChange(String uid, boolean requiresDiscovery, String name, String[] descriptions) {
        super(uid, requiresDiscovery, name, descriptions);
    }

    protected void configureChange(int euChange, int mjChange) {
        this.euChange = euChange;
        this.mjChange = mjChange;
    }

    @Override
    public boolean isCircuitable(TileEntity tile) {
        return tile instanceof EngineTin;
    }

    @Override
    public void onInsertion(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)tile;
        engine.changeEnergyConfig(this.euChange, this.mjChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(int slot, TileEntity tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)tile;
        engine.changeEnergyConfig(-this.euChange, -this.mjChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(int slot, TileEntity tile) {
    }
}

