/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TankSlot;
import forestry.core.utils.TileInventoryAdapter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class EngineBronze
extends Engine
implements ISpecialInventory,
ILiquidTankContainer {
    public static final short SLOT_CAN = 0;
    public TankSlot fuelTank = new TankSlot(10000);
    public TankSlot heatingTank = new TankSlot(10000);
    private TileInventoryAdapter inventory;
    public int currentLiquidId;
    public int currentLiquidMeta;
    public int burnTime;
    public int totalTime;
    private boolean shutdown;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = super.getPacketPayload();
        if (this.shutdown) {
            payload.append(new int[]{1});
        } else {
            payload.append(new int[]{0});
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        super.fromPacketPayload(payload);
        this.shutdown = payload.intPayload[3] > 0;
    }

    public EngineBronze() {
        super(10000, 100000, 500);
        this.setHints((String[])Config.hints.get("engine.bronze"));
        this.inventory = new TileInventoryAdapter(this, 1, "Items");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineBronzeGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        super.updateServerSide();
        if (this.inventory.func_70301_a(0) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(0))) != null) {
            TankSlot tank = null;
            if (container.stillLiquid.isLiquidEqual(new LiquidStack(Block.field_71938_D.field_71990_ca, 1))) {
                tank = this.heatingTank;
            } else if (FuelManager.bronzeEngineFuel.containsKey(container.stillLiquid.asItemStack())) {
                tank = this.fuelTank;
            }
            if (tank != null) {
                this.inventory.func_70299_a(0, this.replenishByContainer(this.inventory.func_70301_a(0), container, tank));
                if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
                    this.inventory.func_70299_a(0, null);
                }
            }
        }
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        if (this.getHeatLevel() <= 0.2 && this.heatingTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOHEAT);
        } else if (this.burnTime <= 0 && this.fuelTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isActivated() && (this.fuelTank.quantity >= 1000 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.quantity > 0 && this.heatingTank.liquidId == Block.field_71938_D.field_71990_ca) {
                this.addHeat(20);
                --this.heatingTank.quantity;
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    if (this.currentLiquidId > 0) {
                        this.currentOutput = this.determineFuelValue(new ItemStack(this.currentLiquidId, 1, this.currentLiquidMeta));
                        this.addEnergy(this.currentOutput);
                    }
                } else {
                    this.burnTime = this.totalTime = this.determineBurnTime(this.fuelTank.getLiquid().asItemStack());
                    this.currentLiquidId = this.fuelTank.liquidId;
                    this.currentLiquidMeta = this.fuelTank.liquidMeta;
                    this.fuelTank.drain(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if ((fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(new ItemStack(this.currentLiquidId, 1, this.currentLiquidMeta))) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isActivated()) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private int determineFuelValue(ItemStack item) {
        if (FuelManager.bronzeEngineFuel.containsKey(item)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)item)).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnTime(ItemStack item) {
        if (FuelManager.bronzeEngineFuel.containsKey(item)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)item)).burnDuration;
        }
        return 0;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    public int getFuelScaled(int i) {
        return this.fuelTank.quantity * i / 10000;
    }

    public int getHeatingFuelScaled(int i) {
        return this.heatingTank.quantity * i / 10000;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("CurrentLiquidId")) {
            this.currentLiquidId = nbttagcompound.func_74762_e("CurrentLiquidId");
        }
        if (nbttagcompound.func_74764_b("CurrentLiquidMeta")) {
            this.currentLiquidMeta = nbttagcompound.func_74762_e("CurrentLiquidMeta");
        }
        this.burnTime = nbttagcompound.func_74762_e("EngineBurnTime");
        this.totalTime = nbttagcompound.func_74762_e("EngineTotalTime");
        this.fuelTank = new TankSlot(10000);
        this.heatingTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("FuelSlot")) {
            this.fuelTank.readFromNBT(nbttagcompound.func_74775_l("FuelSlot"));
            this.heatingTank.readFromNBT(nbttagcompound.func_74775_l("HeatingSlot"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("CurrentLiquidId", this.currentLiquidId);
        nbttagcompound.func_74768_a("CurrentLiquidMeta", this.currentLiquidMeta);
        nbttagcompound.func_74768_a("EngineBurnTime", this.burnTime);
        nbttagcompound.func_74768_a("EngineTotalTime", this.totalTime);
        NBTTagCompound nbtFuelSlot = new NBTTagCompound();
        NBTTagCompound nbtHeatingSlot = new NBTTagCompound();
        this.fuelTank.writeToNBT(nbtFuelSlot);
        this.heatingTank.writeToNBT(nbtHeatingSlot);
        nbttagcompound.func_74782_a("FuelSlot", (NBTBase)nbtFuelSlot);
        nbttagcompound.func_74782_a("HeatingSlot", (NBTBase)nbtHeatingSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.fuelTank.liquidId = j;
                break;
            }
            case 3: {
                this.fuelTank.quantity = j;
                break;
            }
            case 4: {
                this.heatingTank.liquidId = j;
                break;
            }
            case 5: {
                this.heatingTank.quantity = j;
                break;
            }
            case 6: {
                this.currentOutput = j;
                break;
            }
            case 7: {
                this.storedEnergy = j;
                break;
            }
            case 8: {
                this.heat = j;
                break;
            }
            case 9: {
                this.currentLiquidId = j;
                break;
            }
            case 10: {
                this.currentLiquidMeta = j;
                break;
            }
            case 11: {
                this.fuelTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.burnTime);
        iCrafting.func_71112_a(containerEngine, 1, this.totalTime);
        iCrafting.func_71112_a(containerEngine, 2, this.fuelTank.liquidId);
        iCrafting.func_71112_a(containerEngine, 3, this.fuelTank.quantity);
        iCrafting.func_71112_a(containerEngine, 4, this.heatingTank.liquidId);
        iCrafting.func_71112_a(containerEngine, 5, this.heatingTank.quantity);
        iCrafting.func_71112_a(containerEngine, 6, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 7, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 8, this.heat);
        iCrafting.func_71112_a(containerEngine, 9, this.currentLiquidId);
        iCrafting.func_71112_a(containerEngine, 10, this.currentLiquidMeta);
        iCrafting.func_71112_a(containerEngine, 11, this.fuelTank.liquidMeta);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        return this.inventory.addStack(stack, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int used = 0;
        if (FuelManager.bronzeEngineFuel.containsKey(resource.asItemStack())) {
            used = this.fuelTank.fill(resource, doFill);
        }
        if (resource.itemID == Block.field_71938_D.field_71990_ca) {
            used = this.heatingTank.fill(resource, doFill);
        }
        return used;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex == 0) {
            return this.fuelTank.fill(resource, doFill);
        }
        if (tankIndex == 1) {
            return this.heatingTank.fill(resource, doFill);
        }
        return 0;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.fuelTank, this.heatingTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.fuelTank;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }
}

