/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.TileInventoryAdapter;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class EngineCopper
extends Engine
implements ISpecialInventory,
ISidedInventory {
    public static final short SLOT_FUEL = 0;
    public static final short SLOT_WASTE_1 = 1;
    public static final short SLOT_WASTE_COUNT = 4;
    private int fuelItemId;
    private int fuelItemMeta;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private int ashForItem;
    private TileInventoryAdapter inventory;

    public EngineCopper() {
        super(10000, 20000, 400);
        this.setHints((String[])Config.hints.get("engine.copper"));
        this.ashForItem = 7500;
        this.inventory = new TileInventoryAdapter(this, 5, "Items");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private int getFuelSlot() {
        if (this.inventory.func_70301_a(0) == null) {
            return -1;
        }
        if (this.determineFuelValue(this.inventory.func_70301_a(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        for (int i = 1; i <= 4; ++i) {
            if (this.inventory.func_70301_a(i) == null) {
                return i;
            }
            if (this.inventory.func_70301_a((int)i).field_77993_c != ForestryItem.ash.field_77779_bT || this.inventory.func_70301_a((int)i).field_77994_a >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        if (this.mayBurn() && this.burnTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot >= 0 && this.determineBurnDuration(this.inventory.func_70301_a(fuelSlot)) > 0) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NOFUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isActivated()) {
                this.currentOutput = this.determineFuelValue(new ItemStack(this.fuelItemId, 1, this.fuelItemMeta));
                this.addEnergy(this.currentOutput);
            }
        } else if (this.isActivated()) {
            int fuelslot = this.getFuelSlot();
            int wasteslot = this.getFreeWasteSlot();
            if (fuelslot >= 0 && wasteslot >= 0) {
                this.burnTime = this.totalBurnTime = this.determineBurnDuration(this.inventory.func_70301_a(fuelslot));
                if (this.burnTime > 0) {
                    this.fuelItemId = this.inventory.func_70301_a((int)fuelslot).field_77993_c;
                    this.func_70298_a(fuelslot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heat = 0;
        if (this.isBurning()) {
            ++heat;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++heat;
            }
        }
        this.addHeat(heat);
        return heat;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteslot = this.getFreeWasteSlot();
        if (wasteslot >= 0) {
            if (this.inventory.func_70301_a(wasteslot) == null) {
                this.inventory.func_70299_a(wasteslot, new ItemStack(ForestryItem.ash, 1));
            } else {
                ++this.inventory.func_70301_a((int)wasteslot).field_77994_a;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private int determineFuelValue(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)fuel)).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)fuel)).burnDuration;
        }
        return 0;
    }

    private void dumpStash() {
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.field_70331_k, this.Coords(), ForgeDirection.UNKNOWN);
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.func_70301_a(i) == null || this.inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            ForgeDirection[] filtered = BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{this.getOrientation()});
            while (this.inventory.func_70301_a((int)i).field_77994_a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this, filtered, this.inventory.func_70301_a(i));
            }
            if (this.inventory.func_70301_a((int)i).field_77994_a > 0) continue;
            this.inventory.func_70299_a(i, null);
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)fuelSlot).field_77994_a / (float)this.inventory.func_70301_a(fuelSlot).func_77976_d() > percentage;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.fuelItemId = nbttagcompound.func_74762_e("EngineFuelItem");
        this.fuelItemMeta = nbttagcompound.func_74762_e("EngineFuelMeta");
        this.burnTime = nbttagcompound.func_74762_e("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.func_74762_e("EngineTotalTime");
        if (nbttagcompound.func_74764_b("AshProduction")) {
            this.ashProduction = nbttagcompound.func_74762_e("AshProduction");
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("EngineFuelItem", this.fuelItemId);
        nbttagcompound.func_74768_a("EngineFuelMeta", this.fuelItemMeta);
        nbttagcompound.func_74768_a("EngineBurnTime", this.burnTime);
        nbttagcompound.func_74768_a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.func_74768_a("AshProduction", this.ashProduction);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.storedEnergy = j;
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.burnTime);
        iCrafting.func_71112_a(containerEngine, 1, this.totalBurnTime);
        iCrafting.func_71112_a(containerEngine, 2, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 3, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 4, this.heat);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 1 && slotIndex < 5;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 0 && FuelManager.copperEngineFuel.containsKey(itemstack);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (FuelManager.copperEngineFuel.containsKey(stack)) {
            return this.inventory.addStack(stack, 0, 1, false, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.func_70301_a(i) == null || this.inventory.func_70301_a((int)i).field_77993_c != ForestryItem.ash.field_77779_bT) continue;
            ItemStack product = new ItemStack(ForestryItem.ash);
            if (doRemove) {
                this.func_70298_a(i, 1);
            }
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        return res;
    }
}

