/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.render;

import forestry.core.TemperatureState;
import forestry.core.gadgets.Engine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private ModelBase model = new ModelBase(){};
    private String gfxBase;
    private ModelRenderer boiler = new ModelRenderer(this.model, 0, 0);
    private ModelRenderer trunk;
    private ModelRenderer piston;
    private ModelRenderer extension;

    public RenderEngine() {
        this.boiler.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 6, 16);
        this.boiler.field_78800_c = 8.0f;
        this.boiler.field_78797_d = 8.0f;
        this.boiler.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer(this.model, 0, 0);
        this.trunk.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.piston = new ModelRenderer(this.model, 0, 0);
        this.piston.func_78789_a(-6.0f, -2.0f, -6.0f, 12, 4, 12);
        this.piston.field_78800_c = 8.0f;
        this.piston.field_78797_d = 8.0f;
        this.piston.field_78798_e = 8.0f;
        this.extension = new ModelRenderer(this.model, 0, 0);
        this.extension.func_78789_a(-5.0f, -3.0f, -5.0f, 10, 2, 10);
        this.extension.field_78800_c = 8.0f;
        this.extension.field_78797_d = 8.0f;
        this.extension.field_78798_e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(TemperatureState.COOL, 0.25f, ForgeDirection.UP, x, y, z);
    }

    @Override
    public void func_76894_a(TileEntity tile, double d, double d1, double d2, float f) {
        Engine engine = (Engine)tile;
        if (engine != null) {
            this.render(engine.getTemperatureState(), engine.progress, engine.getOrientation(), d, d1, d2);
        }
    }

    private void render(TemperatureState state, float progress, ForgeDirection orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 5.99f - (progress - 0.5f) * 2.0f * 5.99f : progress * 2.0f * 5.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        switch (orientation) {
            case EAST: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.boiler.field_78795_f = angle[0];
        this.boiler.field_78796_g = angle[1];
        this.boiler.field_78808_h = angle[2];
        this.trunk.field_78795_f = angle[0];
        this.trunk.field_78796_g = angle[1];
        this.trunk.field_78808_h = angle[2];
        this.piston.field_78795_f = angle[0];
        this.piston.field_78796_g = angle[1];
        this.piston.field_78808_h = angle[2];
        this.extension.field_78795_f = angle[0];
        this.extension.field_78796_g = angle[1];
        this.extension.field_78808_h = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.gfxBase + "base.png");
        this.boiler.func_78785_a(factor);
        Proxies.common.bindTexture(this.gfxBase + "piston.png");
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.piston.func_78785_a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        Proxies.common.bindTexture(this.gfxBase + "extension.png");
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.extension.func_78785_a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        String texture = "";
        switch (state) {
            case OVERHEATING: {
                texture = "/gfx/forestry/blocks/engine_trunk_highest.png";
                break;
            }
            case RUNNING_HOT: {
                texture = "/gfx/forestry/blocks/engine_trunk_higher.png";
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = "/gfx/forestry/blocks/engine_trunk_high.png";
                break;
            }
            case WARMED_UP: {
                texture = "/gfx/forestry/blocks/engine_trunk_medium.png";
                break;
            }
            default: {
                texture = "/gfx/forestry/blocks/engine_trunk_low.png";
            }
        }
        Proxies.common.bindTexture(texture);
        this.trunk.func_78785_a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

