/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorManager;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.ICraftingPlan;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class MachineFabricator
extends TilePowered
implements ICrafter,
ISpecialInventory,
ILiquidTankContainer {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_1 = 3;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private InventoryAdapter inventory = new InventoryAdapter(30, "Items");
    private TankSlot moltenTank = new TankSlot(2000);
    private int heat = 0;
    private int guiMeltingPoint = 0;
    private LiquidStack pendingSmelt;

    @Override
    protected void configurePowerProvider(IPowerProvider provider) {
        provider.configure(10, 5, 110, 25, 330);
    }

    @Override
    public String func_70303_b() {
        return "factory2.0";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heat", this.heat);
        NBTTagCompound nbtMoltenTank = new NBTTagCompound();
        this.moltenTank.writeToNBT(nbtMoltenTank);
        nbttagcompound.func_74782_a("MoltenTank", (NBTBase)nbtMoltenTank);
        if (this.pendingSmelt != null) {
            NBTTagCompound smelt = new NBTTagCompound();
            this.pendingSmelt.writeToNBT(smelt);
            nbttagcompound.func_74782_a("PendingSmelt", (NBTBase)smelt);
        }
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("Heat");
        this.moltenTank = new TankSlot(2000);
        if (nbttagcompound.func_74764_b("MoltenTank")) {
            this.moltenTank.readFromNBT(nbttagcompound.func_74775_l("MoltenTank"));
        }
        if (nbttagcompound.func_74764_b("PendingSmelt")) {
            NBTTagCompound smelt = nbttagcompound.func_74775_l("PendingSmelt");
            this.pendingSmelt = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)smelt);
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0 && (smelt = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack())) != null && this.heat < smelt.meltingPoint) {
            this.moltenTank.drain(5, true);
        }
        if (this.pendingSmelt != null) {
            int filled = this.moltenTank.fill(this.pendingSmelt, true);
            this.pendingSmelt.amount -= filled;
            if (this.pendingSmelt.amount <= 0) {
                this.pendingSmelt = null;
            }
        } else if (this.moltenTank.quantity < this.moltenTank.capacity && this.inventory.func_70301_a(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.inventory.func_70301_a(0))) != null && smelt.meltingPoint <= this.heat) {
            this.func_70298_a(0, 1);
            this.pendingSmelt = smelt.product.copy();
        }
        this.dissipateHeat();
    }

    @Override
    public boolean workCycle() {
        return this.addHeat(25);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    public Object[] getPlan() {
        if (this.inventory.func_70301_a(1) == null) {
            return null;
        }
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(1));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.getIngredients();
    }

    @Override
    public ItemStack getResult() {
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.func_77571_b().func_77946_l();
    }

    @Override
    public ItemStack takeFromSlot(int slotIndex, boolean consumeRecipe) {
        Item planItem;
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        LiquidStack liquid = myRecipe.molten;
        if (this.removeFromInventory(1, this.inventory.getStacks(3, 9), false)) {
            this.removeFromInventory(1, this.inventory.getStacks(3, 9), true);
            this.moltenTank.drain(liquid.amount, true);
        } else if (consumeRecipe) {
            this.removeFromCraftMatrix(myRecipe);
            this.moltenTank.drain(liquid.amount, true);
        } else {
            return null;
        }
        ItemStack result = myRecipe.internal.func_77571_b().func_77946_l();
        if (this.inventory.func_70301_a(1) != null && (planItem = this.inventory.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
            this.inventory.func_70299_a(1, ((ICraftingPlan)planItem).planUsed(this.inventory.func_70301_a(1), result));
        }
        return result;
    }

    private void removeFromCraftMatrix(Recipe recipe) {
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.func_70301_a(3 + i) == null) continue;
            this.inventory.func_70298_a(3 + i, 1);
        }
    }

    private boolean removeFromInventory(int count, ItemStack[] set, boolean doRemove) {
        boolean hasRemoved = true;
        for (int i = 0; i < count; ++i) {
            ItemStack[] condensedSet;
            for (ItemStack req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    ItemStack pol = this.inventory.func_70301_a(j);
                    if (pol == null || !StackUtils.isItemOreEqual(pol, req)) continue;
                    if (pol.field_77994_a > req.field_77994_a) {
                        if (doRemove) {
                            this.inventory.func_70298_a(j, req.field_77994_a);
                        }
                        req.field_77994_a = 0;
                        continue;
                    }
                    if (doRemove) {
                        this.inventory.func_70298_a(j, req.field_77994_a);
                    }
                    req.field_77994_a -= pol.field_77994_a;
                }
            }
            boolean hasLeft = false;
            for (ItemStack req : condensedSet) {
                if (req == null || req.field_77994_a <= 0) continue;
                hasLeft = true;
            }
            if (!hasLeft) continue;
            hasRemoved = false;
        }
        return hasRemoved;
    }

    @Override
    public boolean isWorking() {
        return this.heat <= 5000;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public int getMeltingPoint() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0) {
            Smelting smelt2 = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack());
            if (smelt2 != null) {
                return smelt2.meltingPoint;
            }
        } else if (this.func_70301_a(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.func_70301_a(0))) != null) {
            return smelt.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.moltenTank.liquidId = j;
                break;
            }
            case 1: {
                this.moltenTank.quantity = j;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                this.guiMeltingPoint = j;
                break;
            }
            case 4: {
                this.moltenTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.moltenTank.liquidId);
        iCrafting.func_71112_a(container, 1, this.moltenTank.quantity);
        iCrafting.func_71112_a(container, 2, this.heat);
        iCrafting.func_71112_a(container, 3, this.getMeltingPoint());
        iCrafting.func_71112_a(container, 4, this.moltenTank.liquidMeta);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (from == ForgeDirection.UP && RecipeManager.findMatchingSmelting(stack) != null) {
            return this.inventory.addStack(stack, 0, 1, false, doAdd);
        }
        return this.inventory.addStack(stack, 12, 18, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack taken = doRemove ? this.takeFromSlot(2, false) : this.getResult();
        if (taken != null) {
            return new ItemStack[]{taken};
        }
        return new ItemStack[0];
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.moltenTank};
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }

    public static class RecipeManager
    implements IFabricatorManager {
        public static ArrayList recipes = new ArrayList();
        private static ArrayList smeltings = new ArrayList();

        @Override
        public void addRecipe(ItemStack plan, LiquidStack molten, ItemStack result, Object[] pattern) {
            recipes.add(new Recipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(pattern, result)));
        }

        @Override
        public void addSmelting(ItemStack resource, LiquidStack molten, int meltingPoint) {
            smeltings.add(new Smelting(resource, molten, meltingPoint));
        }

        public static Recipe findMatchingRecipe(ItemStack plan) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan)) continue;
                return recipe;
            }
            return null;
        }

        public static Recipe findMatchingRecipe(ItemStack plan, LiquidStack liquid, ItemStack[] resources) {
            ItemStack[][] gridResources = new ItemStack[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    gridResources[j][i] = resources[i * 3 + j];
                }
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan, gridResources) || !recipe.hasLiquid(liquid)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static Smelting findMatchingSmelting(ItemStack resource) {
            if (resource == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(resource)) continue;
                return smelting;
            }
            return null;
        }

        public static Smelting findMatchingSmelting(LiquidStack product) {
            if (product == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(product)) continue;
                return smelting;
            }
            return null;
        }

        @Override
        public Map getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.internal.getIngredients(), new Object[]{recipe.internal.func_77571_b()});
            }
            return recipeList;
        }
    }

    public static class Smelting {
        ItemStack resource;
        LiquidStack product;
        int meltingPoint;

        public Smelting(ItemStack resource, LiquidStack molten, int meltingPoint) {
            this.resource = resource;
            this.product = molten;
            this.meltingPoint = meltingPoint;
        }

        public boolean matches(ItemStack resource) {
            return this.resource.func_77969_a(resource);
        }

        public boolean matches(LiquidStack product) {
            return this.product.isLiquidEqual(product);
        }
    }

    public static class Recipe {
        ItemStack plan;
        LiquidStack molten;
        ShapedRecipeCustom internal;

        public Recipe(ItemStack plan, LiquidStack molten, ShapedRecipeCustom internal) {
            this.plan = plan;
            this.molten = molten;
            this.internal = internal;
        }

        public boolean matches(ItemStack plan) {
            if (this.plan == null) {
                return true;
            }
            if (plan == null && this.plan == null) {
                return true;
            }
            if (plan == null && this.plan != null) {
                return false;
            }
            if (this.plan.func_77960_j() == Short.MAX_VALUE) {
                return plan.field_77993_c == this.plan.field_77993_c;
            }
            return plan.func_77969_a(this.plan);
        }

        public boolean matches(ItemStack plan, ItemStack[][] resources) {
            if (!this.matches(plan)) {
                return false;
            }
            return this.internal.matches(resources);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (!resource.isLiquidEqual(this.molten)) {
                return false;
            }
            return this.molten.amount <= resource.amount;
        }

        public LiquidStack getLiquid() {
            return this.molten;
        }

        public IRecipe asIRecipe() {
            return this.internal;
        }
    }
}

