/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineMoistener
extends TilePowered
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    private static final short SLOT_STASH_1 = 0;
    private static final short SLOT_RESERVOIR_1 = 6;
    private static final short SLOT_WORKING = 9;
    private static final short SLOT_PRODUCT = 10;
    private static final short SLOT_RESOURCE = 11;
    private static final short SLOTS_COUNT_RESERVOIR = 3;
    private static final short SLOTS_COUNT_STASH = 6;
    private static final LiquidStack STACK_WATER = new LiquidStack(Block.field_71943_B, 1);
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private InventoryAdapter inventory = new InventoryAdapter(12, "Items");
    public Recipe currentRecipe;
    public int burnTime = 0;
    public int totalTime = 0;
    public int productionTime = 0;
    private int timePerItem = 0;
    private ItemStack currentProduct;
    private ItemStack pendingProduct;

    public MachineMoistener() {
        this.setHints((String[])Config.hints.get("moistener"));
    }

    @Override
    public String func_70303_b() {
        return "factory.4";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.MoistenerGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("BurnTime", this.burnTime);
        nbttagcompound.func_74768_a("TotalTime", this.totalTime);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("PendingProduct", (NBTBase)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.currentProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("CurrentProduct", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_70307_a(nbttagcompound);
        this.burnTime = nbttagcompound.func_74762_e("BurnTime");
        this.totalTime = nbttagcompound.func_74762_e("TotalTime");
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("PendingProduct");
            this.pendingProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        if (nbttagcompound.func_74764_b("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("CurrentProduct");
            this.currentProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        int lightvalue;
        LiquidContainerData container;
        if (this.inventory.func_70301_a(10) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(10))) != null && container.stillLiquid.isLiquidEqual(new ItemStack(Block.field_71943_B))) {
            this.inventory.func_70299_a(10, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(10), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)10).field_77994_a <= 0) {
                this.inventory.func_70299_a(10, null);
            }
        }
        if ((lightvalue = this.field_70331_k.func_72957_l(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) > 11) {
            this.setErrorState(EnumErrorCode.NOTGLOOMY);
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            if (this.resourceTank.quantity <= 0) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            --this.resourceTank.quantity;
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.func_70298_a(11, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.inventory.func_70301_a(9) == null) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.inventory.func_70301_a(9))) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventory.func_70301_a(9));
                this.burnTime = this.totalTime = res.moistenerValue;
            }
        } else {
            this.rotateReservoir();
        }
        if (this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        if (this.inventory.tryAddStack(this.pendingProduct, 10, 1, true)) {
            this.pendingProduct = null;
            return true;
        }
        return false;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(11));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
            this.setErrorState(EnumErrorCode.NORECIPE);
            return;
        }
        this.currentProduct = this.currentRecipe.product;
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private int getFreeSlot(ItemStack deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = this.inventory.func_70301_a(i);
            if (slotStack == null) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !slotStack.func_77969_a(deposit) || slotStack.field_77994_a >= slotStack.func_77976_d()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ItemStack deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, 6, emptyOnly);
    }

    private int getFreeReservoirSlot(ItemStack deposit) {
        return this.getFreeSlot(deposit, 6, 9, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = this.inventory.func_70301_a(i);
            if (slotStack == null || !FuelManager.moistenerResource.containsKey(slotStack)) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(slotStack);
            if (stage >= 0 && res.stage >= stage) continue;
            stage = res.stage;
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        if (this.inventory.func_70301_a(9) != null) {
            ItemStack deposit;
            if (FuelManager.moistenerResource.containsKey(this.inventory.func_70301_a(9))) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventory.func_70301_a(9));
                deposit = res.product.func_77946_l();
            } else {
                deposit = this.inventory.func_70301_a(9).func_77946_l();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (targetSlot < 0) {
                return false;
            }
            if (this.inventory.func_70301_a(targetSlot) == null) {
                this.inventory.func_70299_a(targetSlot, deposit);
            } else {
                ++this.inventory.func_70301_a((int)targetSlot).field_77994_a;
            }
            this.func_70298_a(9, 1);
        }
        if (this.inventory.func_70301_a(9) != null) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(6, 9);
        if (resourceSlot < 0) {
            return false;
        }
        this.inventory.func_70299_a(9, this.inventory.func_70298_a(resourceSlot, 1));
        return true;
    }

    private void rotateReservoir() {
        int targetSlot;
        int resourceSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = 6; i < 9; ++i) {
            if (this.inventory.func_70301_a(i) == null || FuelManager.moistenerResource.containsKey(this.inventory.func_70301_a(i))) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator i$ = slotsToShift.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            ItemStack slotStack = this.inventory.func_70301_a(slot);
            int targetSlot2 = this.getFreeStashSlot(slotStack, true);
            if (targetSlot2 < 0) continue;
            this.inventory.func_70299_a(targetSlot2, slotStack);
            this.inventory.func_70299_a(slot, null);
            ++shiftedSlots;
        }
        for (int i = 0; i < (slotsToShift.size() > 0 ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, 6)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.inventory.func_70301_a(resourceSlot))) >= 0; ++i) {
            if (this.inventory.func_70301_a(targetSlot) == null) {
                this.inventory.func_70299_a(targetSlot, this.inventory.func_70301_a(resourceSlot));
                this.inventory.func_70299_a(resourceSlot, null);
                continue;
            }
            StackUtils.mergeStacks(this.inventory.func_70301_a(resourceSlot), this.inventory.func_70301_a(targetSlot));
            if (this.inventory.func_70301_a(resourceSlot) == null || this.inventory.func_70301_a((int)resourceSlot).field_77994_a > 0) continue;
            this.inventory.func_70299_a(resourceSlot, null);
        }
    }

    @Override
    public boolean workCycle() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.quantity > 0;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.func_70301_a(i) == null) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(this.inventory.func_70301_a(i))) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventory.func_70301_a(i));
            if (!res.item.func_77969_a(this.inventory.func_70301_a(i))) continue;
            max += 64;
            avail += this.inventory.func_70301_a((int)i).field_77994_a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventory.func_70301_a(11) == null) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)11).field_77994_a / (float)this.inventory.func_70301_a(11).func_77976_d() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    protected InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 10) {
            return true;
        }
        if (slotIndex >= 0 && slotIndex < 6) {
            return !FuelManager.moistenerResource.containsKey(itemstack);
        }
        return false;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 11) {
            return RecipeManager.isResource(itemstack);
        }
        if (slotIndex >= 0 && slotIndex < 4) {
            return FuelManager.moistenerResource.containsKey(itemstack);
        }
        return false;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && container.stillLiquid.isLiquidEqual(STACK_WATER)) {
            return this.inventory.addStack(stack, 10, 1, false, doAdd);
        }
        if (from == ForgeDirection.UP || from == ForgeDirection.DOWN) {
            return this.inventory.addStack(stack, 11, 1, false, doAdd);
        }
        return this.inventory.addStack(stack, 0, 4, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack slotStack = this.inventory.func_70301_a(10);
        if (slotStack != null && slotStack.field_77994_a > 0) {
            ItemStack product = new ItemStack(slotStack.field_77993_c, 1, slotStack.func_77960_j());
            if (doRemove) {
                this.inventory.func_70298_a(10, 1);
            }
            return new ItemStack[]{product};
        }
        for (int i = 0; i < 6; ++i) {
            slotStack = this.inventory.func_70301_a(i);
            if (slotStack == null || FuelManager.moistenerResource.containsKey(slotStack)) continue;
            ItemStack product = new ItemStack(slotStack.field_77993_c, 1, slotStack.func_77960_j());
            if (doRemove) {
                this.inventory.func_70298_a(i, 1);
            }
            return new ItemStack[]{product};
        }
        return StackUtils.EMPTY_STACK_ARRAY;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
                break;
            }
            case 6: {
                this.resourceTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.burnTime);
        iCrafting.func_71112_a(container, 1, this.totalTime);
        iCrafting.func_71112_a(container, 2, this.productionTime);
        iCrafting.func_71112_a(container, 3, this.timePerItem);
        iCrafting.func_71112_a(container, 4, this.resourceTank.liquidId);
        iCrafting.func_71112_a(container, 5, this.resourceTank.quantity);
        iCrafting.func_71112_a(container, 6, this.resourceTank.liquidMeta);
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        return res;
    }

    public static class RecipeManager
    implements IMoistenerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(ItemStack resource, ItemStack product, int timePerItem) {
            recipes.add(new Recipe(resource, product, timePerItem));
        }

        public static boolean isResource(ItemStack resource) {
            if (resource == null) {
                return false;
            }
            for (Recipe rec : recipes) {
                if (!StackUtils.isIdenticalItem(resource, rec.resource)) continue;
                return true;
            }
            return false;
        }

        public static Recipe findMatchingRecipe(ItemStack item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map getRecipes() {
            HashMap<ItemStack[], ItemStack[]> recipeList = new HashMap<ItemStack[], ItemStack[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ItemStack[]{recipe.resource}, new ItemStack[]{recipe.product});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public int timePerItem;
        public ItemStack resource;
        public ItemStack product;

        public Recipe(ItemStack resource, ItemStack product, int timePerItem) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public boolean matches(ItemStack res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.func_77969_a(res);
        }
    }
}

