/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.BlockStructure;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.farming.gadgets.TileControl;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileGearbox;
import forestry.farming.gadgets.TileHatch;
import forestry.farming.gadgets.TileValve;
import forestry.plugins.PluginFarming;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFarm
extends BlockStructure {
    public BlockFarm(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 6; ++i) {
            if (i == 1) continue;
            for (TileFarm.EnumFarmBlock block : TileFarm.EnumFarmBlock.values()) {
                ItemStack stack = new ItemStack(id, 1, i);
                NBTTagCompound compound = new NBTTagCompound("tag");
                block.saveToCompound(compound);
                stack.func_77982_d(compound);
                list.add(stack);
            }
        }
    }

    @Override
    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, meta) && (tile = world.func_72796_p(x, y, z)) instanceof TileFarm) {
            TileFarm farm = (TileFarm)tile;
            ItemStack stack = new ItemStack(this.field_71990_ca, 1, meta != 1 ? meta : 0);
            NBTTagCompound compound = new NBTTagCompound("tag");
            farm.getFarmBlock().saveToCompound(compound);
            stack.func_77982_d(compound);
            StackUtils.dropItemStackAsEntity(stack, world, x, y, z);
        }
        return world.func_72832_d(x, y, z, 0, 0, 2);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 2: {
                return new TileGearbox();
            }
            case 3: {
                return new TileHatch();
            }
            case 4: {
                return new TileValve();
            }
            case 5: {
                return new TileControl();
            }
        }
        return new TileFarmPlain();
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    public int func_71857_b() {
        return PluginFarming.modelIdFarmBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        TileFarm.EnumFarmBlock.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return this.getBlockTextureFromSideAndMetadata(TileFarm.EnumFarmBlock.BRICK, side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTextureFromSideAndMetadata(TileFarm.EnumFarmBlock type, int side, int metadata) {
        return Block.field_71973_m[type.base.field_77993_c].func_71858_a(side, type.base.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getOverlayTextureForBlock(int side, int metadata) {
        TileFarm.EnumFarmBlock type = TileFarm.EnumFarmBlock.BRICK_STONE;
        if (metadata == 0 && side == 2) {
            return type.getIcon(1);
        }
        if (metadata == 0 && (side == 0 || side == 1)) {
            return type.getIcon(2);
        }
        switch (metadata) {
            case 1: {
                return type.getIcon(3);
            }
            case 2: {
                return type.getIcon(4);
            }
            case 3: {
                return type.getIcon(5);
            }
            case 4: {
                return type.getIcon(6);
            }
            case 5: {
                return type.getIcon(7);
            }
        }
        return type.getIcon(0);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) == 5;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        ItemStack base = TileFarm.EnumFarmBlock.BRICK_STONE.base;
        if (tile != null && tile instanceof TileFarm) {
            base = ((TileFarm)tile).farmBlock.base;
        }
        return Block.field_71973_m[base.field_77993_c].func_71858_a(side, base.func_77960_j());
    }
}

