/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmHousing;
import forestry.core.GameMode;
import forestry.farming.gadgets.TileFarm;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileGearbox
extends TileFarm
implements IPowerReceptor {
    public static int MIN_ENERGY_RECEIVED = 5;
    public static int MAX_ENERGY_RECEIVED = 20;
    public static int MIN_ACTIVATION_ENERGY = 20;
    public static int MAX_ENERGY = 1000;
    private int activationDelay = 0;
    private int previousDelays = 0;
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileGearbox() {
        this.powerProvider.configurePowerPerdition(0, 100);
        this.powerProvider.configure(1000, MIN_ENERGY_RECEIVED, Math.round((float)MAX_ENERGY_RECEIVED * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)MIN_ACTIVATION_ENERGY * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)MAX_ENERGY * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")));
        this.fixedType = 4;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void updateServerSide() {
        if (this.powerProvider != null) {
            this.powerProvider.update(this);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.activationDelay = nbttagcompound.func_74762_e("ActivationDelay");
        this.previousDelays = nbttagcompound.func_74762_e("PrevDelays");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.func_74768_a("ActivationDelay", this.activationDelay);
        nbttagcompound.func_74768_a("PrevDelays", this.previousDelays);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.field_70331_k.func_72820_D() % 5L * 10L != 0L) {
            return;
        }
        ITileStructure central = this.getCentralTE();
        if (!(central instanceof IFarmHousing)) {
            return;
        }
        if (((IFarmHousing)((Object)central)).doWork()) {
            this.powerProvider.useEnergy(MIN_ACTIVATION_ENERGY, MIN_ACTIVATION_ENERGY, true);
            this.previousDelays = 0;
        } else {
            this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
            ++this.previousDelays;
        }
    }

    @Override
    public int powerRequest(ForgeDirection direction) {
        if (this.getPowerProvider().getEnergyStored() >= (float)this.getPowerProvider().getMaxEnergyStored()) {
            return 0;
        }
        if (!this.isIntegratedIntoStructure()) {
            return 0;
        }
        if (this.getCentralTE() == null) {
            return 0;
        }
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

