/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableStacked
implements IFarmable {
    int blockid;
    int matureHeight;

    public FarmableStacked(int blockid, int matureHeight) {
        this.blockid = blockid;
        this.matureHeight = matureHeight;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == this.blockid;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y + (this.matureHeight - 1), z) != this.blockid) {
            return null;
        }
        return new CropBlock(world, this.blockid, 0, new Vect(x, y + (this.matureHeight - 1), z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return itemstack.field_77993_c == this.blockid;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return world.func_72832_d(x, y, z, this.blockid, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

