/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.core.utils.TankSlot;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerLowLiquid
extends Trigger {
    private float threshold = 0.25f;

    public TriggerLowLiquid(int id, float threshold) {
        super(id, "lowLiquid");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection direction, TileEntity tile, ITriggerParameter parameter) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        TankSlot tank = ((TileFarmPlain)central).getTank();
        return (float)tank.quantity / (float)tank.capacity <= this.threshold;
    }
}

