/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandlerBase;
import forestry.core.gadgets.TileNaturalistChest;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.network.GuiId;
import forestry.lepidopterology.gui.ContainerFlutterlyzer;
import forestry.lepidopterology.gui.GuiFlutterlyzer;
import forestry.lepidopterology.items.ItemFlutterlyzer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerLepidopterology
extends GuiHandlerBase {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case FlutterlyzerGUI: {
                ItemStack equipped = this.getEquippedItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerFlutterlyzer(player.field_71071_by, new ItemFlutterlyzer.FlutterlyzerInventory(player, equipped));
            }
            case LepidopteristChestGUI: {
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
                speciesRoot.getBreedingTracker(world, player.field_71092_bJ).synchToPlayer(player);
                return new ContainerNaturalistInventory(speciesRoot, player.field_71071_by, (TileNaturalistChest)this.getTileForestry(world, x, y, z), 5, 25);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case FlutterlyzerGUI: {
                ItemStack equipped = this.getEquippedItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiFlutterlyzer(player, new ItemFlutterlyzer.FlutterlyzerInventory(player, equipped));
            }
            case LepidopteristChestGUI: {
                TileNaturalistChest tile = (TileNaturalistChest)this.getTileForestry(world, x, y, z);
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
                return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistInventory(speciesRoot, player.field_71071_by, tile, 5, 25), tile);
            }
        }
        return null;
    }
}

