/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;
import forestry.core.utils.Utils;
import forestry.lepidopterology.EnumFlutterType;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.genetics.ButterflyTemplates;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class ButterflyHelper
implements IButterflyRoot {
    private static final String uid = "rootButterflies";
    public static HashMap speciesTemplates = new HashMap();
    public static ArrayList butterflyTemplates = new ArrayList();
    private static ArrayList butterflyMutations = new ArrayList();

    @Override
    public String getUID() {
        return uid;
    }

    @Override
    public Class getMemberClass() {
        return IButterfly.class;
    }

    @Override
    public int getSpeciesCount() {
        return 0;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return stack.field_77993_c == ForestryItem.butterflyGE.field_77779_bT || stack.field_77993_c == ForestryItem.serumGE.field_77779_bT;
    }

    private EnumFlutterType getType(ItemStack stack) {
        if (stack == null) {
            return EnumFlutterType.NONE;
        }
        if (stack.field_77993_c == ForestryItem.butterflyGE.field_77779_bT) {
            return EnumFlutterType.BUTTERFLY;
        }
        if (stack.field_77993_c == ForestryItem.serumGE.field_77779_bT) {
            return EnumFlutterType.SERUM;
        }
        return EnumFlutterType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    @Override
    public IButterfly getMember(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!this.isMember(stack)) {
            return null;
        }
        return new Butterfly(stack.func_77978_p());
    }

    @Override
    public IButterfly getMember(NBTTagCompound compound) {
        return new Butterfly(compound);
    }

    @Override
    public ItemStack getMemberStack(IIndividual butterfly, int type) {
        Item butterflyItem;
        switch (EnumFlutterType.VALUES[type]) {
            case SERUM: {
                butterflyItem = ForestryItem.serumGE;
                break;
            }
            default: {
                butterflyItem = ForestryItem.butterflyGE;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
        butterfly.writeToNBT(nbttagcompound);
        ItemStack stack = new ItemStack(butterflyItem);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    @Override
    public EntityLiving spawnButterflyInWorld(World world, IButterfly butterfly, double x, double y, double z) {
        return (EntityButterfly)Utils.spawnEntity(world, (Entity)new EntityButterfly(world, butterfly), x, y, z);
    }

    @Override
    public boolean isMated(ItemStack stack) {
        IButterfly butterfly = this.getMember(stack);
        if (butterfly == null) {
            return false;
        }
        return butterfly.getMate() != null;
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] template) {
        return new Butterfly(this.templateAsGenome(template));
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return null;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        return null;
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] template) {
        return new ButterflyGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return null;
    }

    @Override
    public Map getGenomeTemplates() {
        return speciesTemplates;
    }

    @Override
    public ArrayList getIndividualTemplates() {
        return butterflyTemplates;
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return ButterflyTemplates.getDefaultTemplate();
    }

    @Override
    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(speciesTemplates.values().size())];
    }

    @Override
    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        butterflyTemplates.add(PluginLepidopterology.butterflyInterface.templateAsIndividual(template));
        speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getTemplate(String identifier) {
        return (IAllele[])speciesTemplates.get(identifier);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        butterflyMutations.add((IButterflyMutation)mutation);
    }

    @Override
    public Collection getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(butterflyMutations);
        }
        return butterflyMutations;
    }

    @Override
    public Collection getCombinations(IAllele other) {
        ArrayList<IButterflyMutation> combinations = new ArrayList<IButterflyMutation>();
        for (IButterflyMutation mutation : this.getMutations(false)) {
            if (!mutation.isPartner(other)) continue;
            combinations.add(mutation);
        }
        return combinations;
    }

    @Override
    public IBreedingTracker getBreedingTracker(World world, String player) {
        String filename = "LepidopteristTracker." + player;
        LepidopteristTracker tracker = (LepidopteristTracker)world.func_72943_a(LepidopteristTracker.class, filename);
        if (tracker == null) {
            tracker = new LepidopteristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }
}

