/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.genetics.ItemGE;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Utils;
import forestry.lepidopterology.EnumFlutterType;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemButterflyGE
extends ItemGE {
    EnumFlutterType type;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemButterflyGE(int id, EnumFlutterType type) {
        super(id);
        this.func_77637_a(Tabs.tabLepidopterology);
        this.type = type;
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    @Override
    protected IIndividual getIndividual(ItemStack itemstack) {
        return PluginLepidopterology.butterflyInterface.getMember(itemstack);
    }

    public String func_77628_j(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return "???";
        }
        IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(itemstack);
        if (butterfly == null) {
            return "???";
        }
        return butterfly.getDisplayName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IButterfly individual : PluginLepidopterology.butterflyInterface.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret()) continue;
            itemList.add(PluginLepidopterology.butterflyInterface.getMemberStack(individual, this.type.ordinal()));
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!Proxies.common.isSimulating(entityItem.field_70170_p) || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (entityItem.field_70170_p.func_72820_D() % 24L != 0L) {
            return false;
        }
        IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(entityItem.func_92059_d());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v)) {
            return false;
        }
        if (entityItem.field_70170_p.func_72907_a(EntityButterfly.class) > PluginLepidopterology.entityConstraint) {
            return false;
        }
        if (Utils.spawnEntity(entityItem.field_70170_p, (Entity)new EntityButterfly(entityItem.field_70170_p, butterfly), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v) != null) {
            if (entityItem.func_92059_d().field_77994_a > 1) {
                --entityItem.func_92059_d().field_77994_a;
            } else {
                entityItem.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        if (renderPass == 0) {
            return 0xFFFFFF;
        }
        if (this.type != EnumFlutterType.SERUM || !itemstack.func_77942_o()) {
            return super.func_82790_a(itemstack, renderPass);
        }
        return this.getColourFromSpecies(AlleleManager.alleleRegistry.getIndividual(itemstack).getGenome().getPrimary(), renderPass);
    }

    @Override
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species != null) {
            return species.getIconColour(renderPass);
        }
        return 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons = new Icon[2];
        this.icons[0] = TextureManager.getInstance().registerItemTex("liquids/jar.bottle");
        this.icons[1] = TextureManager.getInstance().registerItemTex("liquids/jar.contents");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        if (j > 0) {
            return this.icons[1];
        }
        return this.icons[0];
    }
}

