/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.storage.BackpackMode;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class ItemBackpack
extends ItemInventoried {
    IBackpackDefinition info;
    byte type;
    @SideOnly(value=Side.CLIENT)
    private Icon[][] icons;

    public ItemBackpack(int i, IBackpackDefinition info, int type) {
        super(i);
        this.info = info;
        this.type = (byte)type;
        this.func_77625_d(1);
    }

    public IBackpackDefinition getDefinition() {
        return this.info;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (!player.func_70093_af()) {
            this.openGui(player, itemstack);
        } else {
            this.switchMode(itemstack);
        }
        return itemstack;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.getInventoryHit(itemstack, player, world, x, y, z) != null;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        return this.evaluateTileHit(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack tryStowing(EntityPlayer player, ItemStack backpackStack, ItemStack itemstack) {
        ItemBackpack backpack = (ItemBackpack)backpackStack.func_77973_b();
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, backpack.getBackpackSize(), backpackStack);
        if (backpackStack.func_77960_j() == 1) {
            return itemstack;
        }
        BackpackStowEvent event = new BackpackStowEvent(player, backpack.getDefinition(), inventory, itemstack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (itemstack.field_77994_a <= 0) {
            return null;
        }
        if (event.isCanceled()) {
            return itemstack;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int space;
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!slotStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)itemstack) || (space = slotStack.func_77976_d() - slotStack.field_77994_a) <= 0) continue;
            if (space < itemstack.field_77994_a) {
                slotStack.field_77994_a = slotStack.func_77976_d();
                itemstack.field_77994_a -= space;
                continue;
            }
            slotStack.field_77994_a += itemstack.field_77994_a;
            itemstack.field_77994_a = 0;
            inventory.save();
            return null;
        }
        if (freeSlots <= 0) {
            inventory.save();
            return itemstack;
        }
        inventory.func_70299_a(slot, itemstack.func_77946_l());
        itemstack.field_77994_a = 0;
        inventory.save();
        return null;
    }

    private void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.RESUPPLY) {
            itemstack.func_77964_b(0);
        } else if (mode == BackpackMode.RECEIVE) {
            itemstack.func_77964_b(3);
        } else if (mode == BackpackMode.LOCKED) {
            itemstack.func_77964_b(2);
        } else {
            itemstack.func_77964_b(1);
        }
    }

    private MovingObjectPosition getPlayerTarget(EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        return player.field_70170_p.func_72933_a(posVec, lookVec);
    }

    private IInventory getInventoryHit(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z) {
        IInventory inventory = null;
        MovingObjectPosition movingobjectposition = this.getPlayerTarget(player);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            IInventory test;
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            TileEntity targeted = world.func_72796_p(i, j, k);
            if (targeted instanceof TileEntityChest) {
                inventory = Utils.getChest((IInventory)targeted);
            } else if (targeted instanceof IInventory && (test = (IInventory)targeted).func_70302_i_() > 26) {
                inventory = test;
            }
        }
        return inventory;
    }

    private boolean evaluateTileHit(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        IInventory inventory = this.getInventoryHit(itemstack, player, world, x, y, z);
        if (inventory != null) {
            if (inventory.func_70302_i_() <= 0) {
                return true;
            }
            ItemInventory backpackInventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), itemstack);
            if (itemstack.func_77960_j() == 2) {
                this.tryChestReceive(player, backpackInventory, inventory);
            } else {
                this.tryChestTransfer(backpackInventory, inventory);
            }
            backpackInventory.save();
            return true;
        }
        return false;
    }

    private void tryChestTransfer(ItemInventory backpackInventory, IInventory inventory) {
        block0: for (int l = 0; l < backpackInventory.func_70302_i_(); ++l) {
            ItemStack packstack = backpackInventory.func_70301_a(l);
            if (packstack == null) continue;
            for (int m = 0; m < inventory.func_70302_i_(); ++m) {
                int space;
                ItemStack targetstack = inventory.func_70301_a(m);
                if (!inventory.func_94041_b(m, packstack)) continue;
                if (targetstack == null) {
                    inventory.func_70299_a(m, packstack.func_77946_l());
                    backpackInventory.func_70299_a(l, null);
                    continue block0;
                }
                if (!targetstack.func_77969_a(packstack) || !ItemStack.func_77970_a((ItemStack)targetstack, (ItemStack)packstack) || (space = targetstack.func_77976_d() - targetstack.field_77994_a) <= 0) continue;
                if (space >= packstack.field_77994_a) {
                    targetstack.field_77994_a += packstack.field_77994_a;
                    backpackInventory.func_70298_a(l, packstack.field_77994_a);
                    continue block0;
                }
                targetstack.field_77994_a = targetstack.func_77976_d();
                backpackInventory.func_70298_a(l, space);
            }
        }
    }

    private void tryChestReceive(EntityPlayer player, ItemInventory backpackInventory, IInventory inventory) {
        block0: for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null || !this.info.isValidItem(player, inventoryStack)) continue;
            for (int j = 0; j < backpackInventory.func_70302_i_(); ++j) {
                int space;
                ItemStack backpackStack = backpackInventory.func_70301_a(j);
                if (backpackStack == null) {
                    backpackInventory.func_70299_a(j, inventoryStack.func_77946_l());
                    inventory.func_70299_a(i, null);
                    continue block0;
                }
                if (!backpackStack.func_77969_a(inventoryStack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)backpackStack) || (space = backpackStack.func_77976_d() - backpackStack.field_77994_a) <= 0) continue;
                if (space >= inventoryStack.field_77994_a) {
                    backpackStack.field_77994_a += inventoryStack.field_77994_a;
                    inventory.func_70298_a(i, inventoryStack.field_77994_a);
                    continue block0;
                }
                backpackStack.field_77994_a = backpackStack.func_77976_d();
                inventory.func_70298_a(i, space);
            }
        }
    }

    public void openGui(EntityPlayer entityplayer, ItemStack itemstack) {
        if (this.getBackpackSize() == 15) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackGUI.ordinal(), entityplayer.field_70170_p, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        } else if (this.getBackpackSize() == 45) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackT2GUI.ordinal(), entityplayer.field_70170_p, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
    }

    public boolean isBackpack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.field_77993_c == this.field_77779_bT;
    }

    public Collection getValidItems(EntityPlayer player) {
        return this.info.getValidItems(player);
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), itemstack);
        int occupied = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            ++occupied;
        }
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add("(LOCKED)");
        } else if (mode == BackpackMode.RECEIVE) {
            list.add("(RECEIVING)");
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add("(RESUPPLY)");
        }
        list.add(occupied + "/" + this.getBackpackSize() + " " + StringUtil.localize("gui.slots"));
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        if (this.type > 1) {
            return StringUtil.localize("storage.backpack.t2adj") + " " + this.info.getName();
        }
        return this.info.getName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons = new Icon[EnumBackpackType.values().length][6];
        for (int i = 0; i < EnumBackpackType.values().length; ++i) {
            this.icons[i][0] = TextureManager.getInstance().registerItemTex("backpacks/" + EnumBackpackType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".cloth");
            this.icons[i][1] = TextureManager.getInstance().registerItemTex("backpacks/" + EnumBackpackType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][2] = TextureManager.getInstance().registerItemTex("backpacks/neutral");
            this.icons[i][3] = TextureManager.getInstance().registerItemTex("backpacks/locked");
            this.icons[i][4] = TextureManager.getInstance().registerItemTex("backpacks/receive");
            this.icons[i][5] = TextureManager.getInstance().registerItemTex("backpacks/resupply");
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0) {
            return this.info.getPrimaryColour();
        }
        if (j == 1) {
            return this.info.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        int iconType = this.type;
        if (this.type > 0) {
            --iconType;
        }
        if (j == 0) {
            return this.icons[iconType][0];
        }
        if (j == 1) {
            return this.icons[iconType][1];
        }
        if (i > 2) {
            return this.icons[iconType][5];
        }
        if (i > 1) {
            return this.icons[iconType][4];
        }
        if (i > 0) {
            return this.icons[iconType][3];
        }
        return this.icons[iconType][2];
    }

    public static int getSlotsForType(int type) {
        switch (type) {
            case 0: {
                return 125;
            }
            case 2: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ItemStack backpack) {
        int meta = backpack.func_77960_j();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }
}

