/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTPolygon;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import com.overminddl1.mods.NMT.NMTVertex;
import java.util.ArrayList;

public abstract class NMTModelBase {
    public String name;
    protected NMTModelRenderer renderer;
    public ArrayList polygons;
    public ArrayList vertices;
    public boolean doCompile;
    public boolean doRender;

    public NMTModelBase(NMTModelRenderer nmtmodelrenderer) {
        this.renderer = nmtmodelrenderer;
        this.polygons = new ArrayList();
        this.vertices = new ArrayList();
        this.doCompile = true;
        this.doRender = false;
    }

    public abstract NMTModelBase create();

    public void compile(bge tessellator, float scale) {
        this.render(tessellator, scale);
    }

    public void render(bge tessellator, float scale) {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            ((NMTPolygon)this.polygons.get(idx)).draw(tessellator, scale, this.renderer.disableTextureMapping);
        }
    }

    public NMTTextureVertex addVertex(float x, float y, float z, float u, float v) {
        NMTVertex vertex = new NMTVertex(x, y, z);
        this.vertices.add(vertex);
        return this.addVertex(vertex, u, v);
    }

    public NMTTextureVertex addVertex(NMTVertex vertex, float u, float v) {
        return new NMTTextureVertex(vertex, u, v);
    }

    public NMTTextureVertex addVertex(NMTVertex vertex, float u, float v, arc n) {
        return new NMTTextureVertex(vertex, u, v, n);
    }

    public NMTTextureVertex addVertexFromOrig(NMTVertex vertex, float u, float v, arc n) {
        arc calcN = arc.a((double)(vertex.transformVector.c - n.c), (double)(vertex.transformVector.d - n.d), (double)(vertex.transformVector.e - n.e));
        calcN = calcN.a();
        return new NMTTextureVertex(vertex, u, v, calcN);
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex((NMTVertex)this.vertices.get(vert1), u2, v1), this.addVertex((NMTVertex)this.vertices.get(vert2), u1, v1), this.addVertex((NMTVertex)this.vertices.get(vert3), u1, v2), this.addVertex((NMTVertex)this.vertices.get(vert4), u2, v2)}));
    }

    public void addQuad(ArrayList verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex((NMTVertex)verts.get(vert1), u2, v1), this.addVertex((NMTVertex)verts.get(vert2), u1, v1), this.addVertex((NMTVertex)verts.get(vert3), u1, v2), this.addVertex((NMTVertex)verts.get(vert4), u2, v2)}));
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, arc orig) {
        NMTPolygon poly = new NMTPolygon(new NMTTextureVertex[]{this.addVertexFromOrig((NMTVertex)this.vertices.get(vert1), u2, v1, orig), this.addVertexFromOrig((NMTVertex)this.vertices.get(vert2), u1, v1, orig), this.addVertexFromOrig((NMTVertex)this.vertices.get(vert3), u1, v2, orig), this.addVertexFromOrig((NMTVertex)this.vertices.get(vert4), u2, v2, orig)});
        poly.indivNormal = true;
        this.polygons.add(poly);
    }

    public void addQuad(ArrayList verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, arc orig) {
        NMTPolygon poly = new NMTPolygon(new NMTTextureVertex[]{this.addVertexFromOrig((NMTVertex)verts.get(vert1), u2, v1, orig), this.addVertexFromOrig((NMTVertex)verts.get(vert2), u1, v1, orig), this.addVertexFromOrig((NMTVertex)verts.get(vert3), u1, v2, orig), this.addVertexFromOrig((NMTVertex)verts.get(vert4), u2, v2, orig)});
        poly.indivNormal = true;
        this.polygons.add(poly);
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, arc[] n) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex((NMTVertex)this.vertices.get(vert1), u2, v1, n[0]), this.addVertex((NMTVertex)this.vertices.get(vert2), u1, v1, n[1]), this.addVertex((NMTVertex)this.vertices.get(vert3), u1, v2, n[2]), this.addVertex((NMTVertex)this.vertices.get(vert4), u2, v2, n[3])}));
    }

    public void addQuad(ArrayList verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, arc[] n) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex((NMTVertex)verts.get(vert1), u2, v1, n[0]), this.addVertex((NMTVertex)verts.get(vert2), u1, v1, n[1]), this.addVertex((NMTVertex)verts.get(vert3), u1, v2, n[2]), this.addVertex((NMTVertex)verts.get(vert4), u2, v2, n[3])}));
    }

    public NMTModelBase setName(String s) {
        this.name = s;
        return this;
    }

    public void invertNormals() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            ((NMTPolygon)this.polygons.get((int)idx)).invertNormal = true;
        }
    }

    public void flipFaces() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            ((NMTPolygon)this.polygons.get(idx)).flipFace();
        }
    }

    public void setIndivNormals() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            ((NMTPolygon)this.polygons.get((int)idx)).indivNormal = true;
        }
    }

    public final ArrayList getVertexList() {
        return this.vertices;
    }

    public void doMirror(boolean x, boolean y, boolean z) {
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            NMTVertex vert = (NMTVertex)this.vertices.get(idx);
            vert.baseVector.c = vert.baseVector.c * (double)(x ? -1 : 1);
            vert.baseVector.d = vert.baseVector.d * (double)(y ? -1 : 1);
            vert.baseVector.e = vert.baseVector.e * (double)(z ? -1 : 1);
        }
        if (x ^ y ^ z) {
            this.flipFaces();
        }
    }

    protected void setNormalFromOrigin(NMTVertex vertex, arc n) {
        arc calcN = arc.a((double)(vertex.transformVector.c - n.c), (double)(vertex.transformVector.d - n.d), (double)(vertex.transformVector.e - n.e));
        calcN = calcN.a();
        vertex.setNormals(calcN);
    }
}

