/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTVertex;

public class NMTModelBox
extends NMTModelBase {
    private float xPos;
    private float yPos;
    private float zPos;
    private int width;
    private int height;
    private int depth;
    private float scale;
    private float extrusion;
    private boolean calcNormals;

    public NMTModelBox(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, int w, int h, int d, float e, float s, boolean cN) {
        super(nmtmodelrenderer);
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.width = w;
        this.height = h;
        this.depth = d;
        this.scale = s;
        this.extrusion = e;
        this.calcNormals = cN;
    }

    @Override
    public NMTModelBox create() {
        float x1 = this.xPos - (float)((double)((float)this.width * (this.scale - 1.0f)) * 0.5);
        float y1 = this.yPos - (float)((double)((float)this.height * (this.scale - 1.0f)) * 0.5);
        float z1 = this.zPos - (float)((double)((float)this.depth * (this.scale - 1.0f)) * 0.5);
        float x2 = x1 + (float)this.width * this.scale;
        float y2 = y1 + (float)this.height * this.scale;
        float z2 = z1 + (float)this.depth * this.scale;
        x1 -= this.extrusion;
        y1 -= this.extrusion;
        z1 -= this.extrusion;
        x2 += this.extrusion;
        y2 += this.extrusion;
        z2 += this.extrusion;
        float u = this.renderer.textureU;
        float v = this.renderer.textureV;
        float texW = this.renderer.a;
        float texH = this.renderer.b;
        if (this.renderer.i) {
            float x3 = x2;
            x2 = x1;
            x1 = x3;
        }
        this.vertices.add(new NMTVertex(x1, y1, z1));
        this.vertices.add(new NMTVertex(x2, y1, z1));
        this.vertices.add(new NMTVertex(x2, y2, z1));
        this.vertices.add(new NMTVertex(x1, y2, z1));
        this.vertices.add(new NMTVertex(x1, y1, z2));
        this.vertices.add(new NMTVertex(x2, y1, z2));
        this.vertices.add(new NMTVertex(x2, y2, z2));
        this.vertices.add(new NMTVertex(x1, y2, z2));
        if (this.calcNormals) {
            arc centerVec = arc.a((double)(x1 + (x2 - x1) / 2.0f), (double)(y1 + (y2 - y1) / 2.0f), (double)(z1 + (z2 - z1) / 2.0f));
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(0), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(1), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(2), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(3), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(4), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(5), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(6), centerVec);
            this.setNormalFromOrigin((NMTVertex)this.vertices.get(7), centerVec);
        }
        this.addQuad(5, 1, 2, 6, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)(this.depth * 2) + (float)this.width) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuad(0, 4, 7, 3, u / texW, (v + (float)this.depth) / texH, (u + (float)this.depth) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuad(5, 4, 0, 1, (u + (float)this.depth) / texW, v / texH, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH);
        this.addQuad(2, 3, 7, 6, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)this.depth + (float)(this.width * 2)) / texW, v / texH);
        this.addQuad(1, 0, 3, 2, (u + (float)this.depth) / texW, (v + (float)this.depth) / texH, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuad(4, 5, 6, 7, (u + (float)(this.depth * 2) + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)(this.depth * 2) + (float)(this.width * 2)) / texW, (v + (float)this.depth + (float)this.height) / texH);
        if (this.renderer.i) {
            this.flipFaces();
        }
        if (this.calcNormals) {
            this.setIndivNormals();
        }
        return this;
    }
}

