/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelBox;
import com.overminddl1.mods.NMT.NMTModelFileOBJ;
import com.overminddl1.mods.NMT.NMTModelSphere;
import com.overminddl1.mods.NMT.NMTModelSprite;
import com.overminddl1.mods.NMT.NMTModelTrapezoid;
import com.overminddl1.mods.NMT.NMTModelVoxel;
import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class NMTModelRenderer
extends bdj {
    private boolean compiled;
    private int displayList;
    private bce baseModel;
    public int textureU;
    public int textureV;
    public ArrayList modelList;
    public boolean disableTextureMapping;
    public boolean recompile;

    public NMTModelRenderer(bce modelbase, String s) {
        super(modelbase, s);
        this.baseModel = modelbase;
        this.compiled = false;
        this.displayList = 0;
        this.modelList = new ArrayList();
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(bce modelbase) {
        super(modelbase);
        this.compiled = false;
        this.baseModel = modelbase;
        this.displayList = 0;
        this.modelList = new ArrayList();
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(bce modelbase, int textureX, int textureY) {
        super(modelbase, textureX, textureY);
        this.compiled = false;
        this.baseModel = modelbase;
        this.displayList = 0;
        this.modelList = new ArrayList();
        this.a(textureX, textureY);
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(bce modelbase, int textureX, int textureY, int textureW, int textureH) {
        this(modelbase, textureX, textureY);
        this.b(textureW, textureH);
    }

    public bdj a(int u, int v) {
        super.a(u, v);
        this.textureU = u;
        this.textureV = v;
        return this;
    }

    public NMTModelRenderer addModel(String name, NMTModelBase model) {
        name = this.n + "." + name;
        bdk textureoffset = this.baseModel.a(name);
        this.a(textureoffset.a, textureoffset.b);
        this.modelList.add(model.create().setName(name));
        return this;
    }

    public NMTModelRenderer addModel(NMTModelBase model) {
        this.modelList.add(model.create());
        return this;
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth) {
        return this.addBox(name, x, y, z, width, height, depth, 0.0f);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion) {
        return this.addBox(name, x, y, z, width, height, depth, extrusion, 1.0f);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion, float scale) {
        return this.addBox(name, x, y, z, width, height, depth, extrusion, scale, false);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion, float scale, boolean smooth) {
        return this.addModel(name, new NMTModelBox(this, x, y, z, width, height, depth, extrusion, scale, smooth));
    }

    public NMTModelRenderer addBox(float x, float y, float z, int width, int height, int depth) {
        return this.addBox(x, y, z, width, height, depth, 0.0f, 1.0f, false);
    }

    public void a(float x, float y, float z, int width, int height, int depth, float extrusion) {
        this.addBox(x, y, z, width, height, depth, extrusion, 1.0f);
    }

    public void addBox(float x, float y, float z, int width, int height, int depth, float extrusion, float scale) {
        this.addBox(x, y, z, width, height, depth, extrusion, scale, false);
    }

    public NMTModelRenderer addBox(float x, float y, float z, int width, int height, int depth, float extrusion, float scale, boolean smooth) {
        return this.addModel(new NMTModelBox(this, x, y, z, width, height, depth, extrusion, scale, smooth));
    }

    public NMTModelRenderer addTrapezoid(String name, float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        return this.addModel(name, new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir));
    }

    public NMTModelRenderer addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        return this.addModel(new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir));
    }

    public NMTModelRenderer addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir, boolean smooth) {
        return this.addModel(new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir, smooth));
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z) {
        return this.addVoxel(name, x, y, z, 1.0f, 1.0f, 1.0f);
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z, float width, float height, float depth) {
        return this.addVoxel(name, x, y, z, width, height, depth, 0, 0);
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z, float width, float height, float depth, int relativeU, int relativeV) {
        return this.addModel(name, new NMTModelVoxel(this, x, y, z, width, height, depth, relativeU, relativeV));
    }

    public NMTModelRenderer addVoxel(float x, float y, float z, float width, float height, float depth) {
        return this.addVoxel(x, y, z, width, height, depth, 0, 0);
    }

    public NMTModelRenderer addVoxel(float x, float y, float z, float width, float height, float depth, int relativeU, int relativeV) {
        return this.addModel(new NMTModelVoxel(this, x, y, z, width, height, depth, relativeU, relativeV));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow, boolean rotX, boolean rotY, boolean rotZ) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow, rotX, rotY, rotZ));
    }

    public NMTModelRenderer addSphere(float x, float y, float z, float r, int slices, int stacks, int tW, int tH, boolean cN, int mappingUsed) {
        return this.addModel(new NMTModelSphere(this, x, y, z, r, slices, stacks, tW, tH, cN, mappingUsed));
    }

    public NMTModelRenderer addModelOBJ(String name, String file) {
        try {
            return this.addModel(name, new NMTModelFileOBJ(this, file));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public NMTModelRenderer addModelOBJ(String file) {
        try {
            return this.addModel(new NMTModelFileOBJ(this, file));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void copyRotations(bdj model) {
        this.f = model.f;
        this.g = model.g;
        this.h = model.h;
    }

    public void a(float f) {
        if (this.k) {
            return;
        }
        if (!this.j) {
            return;
        }
        if (!this.compiled || this.recompile) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.c * f), (float)(this.d * f), (float)(this.e * f));
        if (this.g != 0.0f) {
            GL11.glRotatef((float)(this.g * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.f != 0.0f) {
            GL11.glRotatef((float)(this.f * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.h != 0.0f) {
            GL11.glRotatef((float)(this.h * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.displayList);
        this.renderList(f);
        GL11.glPopMatrix();
    }

    private void compileDisplayList(float f) {
        this.displayList = avc.a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        bge tessellator = bge.a;
        for (int i = 0; i < this.modelList.size(); ++i) {
            NMTModelBase model = (NMTModelBase)this.modelList.get(i);
            if (!model.doCompile) continue;
            model.compile(tessellator, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    private void renderList(float f) {
        bge tessellator = bge.a;
        for (int i = 0; i < this.modelList.size(); ++i) {
            NMTModelBase model = (NMTModelBase)this.modelList.get(i);
            if (!model.doRender) continue;
            model.render(tessellator, f);
        }
    }
}

