/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTVertex;
import java.util.ArrayList;

public class NMTModelTrapezoid
extends NMTModelBase {
    private float xPos;
    private float yPos;
    private float zPos;
    private int width;
    private int height;
    private int depth;
    private float scale;
    private float bottomScale;
    private int direction;
    private int xSub;
    private int ySub;
    private int zSub;
    private boolean smooth;

    public NMTModelTrapezoid(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, int w, int h, int d, float s, float bScale, int dir) {
        this(nmtmodelrenderer, x, y, z, w, h, d, s, bScale, dir, w, h, d);
    }

    public NMTModelTrapezoid(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, int w, int h, int d, float s, float bScale, int dir, boolean sm) {
        this(nmtmodelrenderer, x, y, z, w, h, d, s, bScale, dir, w, h, d);
        this.smooth = sm;
    }

    public NMTModelTrapezoid(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, int w, int h, int d, float s, float bScale, int dir, int xS, int yS, int zS) {
        this(nmtmodelrenderer, x, y, z, w, h, d, s, bScale, dir, xS, yS, zS, false);
    }

    public NMTModelTrapezoid(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, int w, int h, int d, float s, float bScale, int dir, int xS, int yS, int zS, boolean sm) {
        super(nmtmodelrenderer);
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.width = w;
        this.height = h;
        this.depth = d;
        this.scale = s;
        this.bottomScale = bScale;
        this.direction = dir;
        this.xSub = xS;
        this.ySub = yS;
        this.zSub = zS;
        this.smooth = sm;
    }

    @Override
    public NMTModelTrapezoid create() {
        int m;
        float x1 = this.xPos - (float)((double)((float)this.width * (this.scale - 1.0f)) * 0.5);
        float y1 = this.yPos - (float)((double)((float)this.height * (this.scale - 1.0f)) * 0.5);
        float z1 = this.zPos - (float)((double)((float)this.depth * (this.scale - 1.0f)) * 0.5);
        float x2 = x1 + (float)this.width * this.scale;
        float y2 = y1 + (float)this.height * this.scale;
        float z2 = z1 + (float)this.depth * this.scale;
        float u = this.renderer.textureU;
        float v = this.renderer.textureV;
        float texW = this.renderer.a;
        float texH = this.renderer.b;
        int n = m = this.renderer.i ? -1 : 1;
        if (this.renderer.i) {
            float x3 = x2;
            x2 = x1;
            x1 = x3;
        }
        arc centerVec = arc.a((double)(x1 + (x2 - x1) / 2.0f), (double)(y1 + (y2 - y1) / 2.0f), (double)(z1 + (z2 - z1) / 2.0f));
        float[][] vert = this.setDirection(new float[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y2, z1}, {x1, y2, z1}, {x1, y1, z2}, {x2, y1, z2}, {x2, y2, z2}, {x1, y2, z2}}, m);
        ArrayList verts = this.setupVertices(vert, centerVec);
        this.addQuadSet((NMTVertex[][])verts.get(2), this.zSub, this.ySub, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)(this.depth * 2) + (float)this.width) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuadSet((NMTVertex[][])verts.get(3), this.zSub, this.ySub, u / texW, (v + (float)this.depth) / texH, (u + (float)this.depth) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuadSet((NMTVertex[][])verts.get(4), this.xSub, this.zSub, (u + (float)this.depth) / texW, v / texH, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH);
        this.addQuadSet((NMTVertex[][])verts.get(5), this.xSub, this.zSub, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)this.depth + (float)(this.width * 2)) / texW, v / texH);
        this.addQuadSet((NMTVertex[][])verts.get(0), this.xSub, this.ySub, (u + (float)this.depth) / texW, (v + (float)this.depth) / texH, (u + (float)this.depth + (float)this.width) / texW, (v + (float)this.depth + (float)this.height) / texH);
        this.addQuadSet((NMTVertex[][])verts.get(1), this.xSub, this.ySub, (u + (float)(this.depth * 2) + (float)this.width) / texW, (v + (float)this.depth) / texH, (u + (float)(this.depth * 2) + (float)(this.width * 2)) / texW, (v + (float)this.depth + (float)this.height) / texH);
        if (this.renderer.i) {
            this.flipFaces();
        }
        return this;
    }

    private float[][] setDirection(float[][] v, int m) {
        switch (this.direction) {
            case 3: {
                float[] fArray = v[0];
                fArray[1] = fArray[1] - this.bottomScale;
                float[] fArray2 = v[0];
                fArray2[2] = fArray2[2] - this.bottomScale;
                float[] fArray3 = v[3];
                fArray3[1] = fArray3[1] + this.bottomScale;
                float[] fArray4 = v[3];
                fArray4[2] = fArray4[2] - this.bottomScale;
                float[] fArray5 = v[4];
                fArray5[1] = fArray5[1] - this.bottomScale;
                float[] fArray6 = v[4];
                fArray6[2] = fArray6[2] + this.bottomScale;
                float[] fArray7 = v[7];
                fArray7[1] = fArray7[1] + this.bottomScale;
                float[] fArray8 = v[7];
                fArray8[2] = fArray8[2] + this.bottomScale;
                break;
            }
            case 2: {
                float[] fArray = v[1];
                fArray[1] = fArray[1] - this.bottomScale;
                float[] fArray9 = v[1];
                fArray9[2] = fArray9[2] - this.bottomScale;
                float[] fArray10 = v[2];
                fArray10[1] = fArray10[1] + this.bottomScale;
                float[] fArray11 = v[2];
                fArray11[2] = fArray11[2] - this.bottomScale;
                float[] fArray12 = v[5];
                fArray12[1] = fArray12[1] - this.bottomScale;
                float[] fArray13 = v[5];
                fArray13[2] = fArray13[2] + this.bottomScale;
                float[] fArray14 = v[6];
                fArray14[1] = fArray14[1] + this.bottomScale;
                float[] fArray15 = v[6];
                fArray15[2] = fArray15[2] + this.bottomScale;
                break;
            }
            case 0: {
                float[] fArray = v[0];
                fArray[0] = fArray[0] - (float)m * this.bottomScale;
                float[] fArray16 = v[0];
                fArray16[1] = fArray16[1] - this.bottomScale;
                float[] fArray17 = v[1];
                fArray17[0] = fArray17[0] + (float)m * this.bottomScale;
                float[] fArray18 = v[1];
                fArray18[1] = fArray18[1] - this.bottomScale;
                float[] fArray19 = v[2];
                fArray19[0] = fArray19[0] + (float)m * this.bottomScale;
                float[] fArray20 = v[2];
                fArray20[1] = fArray20[1] + this.bottomScale;
                float[] fArray21 = v[3];
                fArray21[0] = fArray21[0] - (float)m * this.bottomScale;
                float[] fArray22 = v[3];
                fArray22[1] = fArray22[1] + this.bottomScale;
                break;
            }
            case 1: {
                float[] fArray = v[4];
                fArray[0] = fArray[0] - (float)m * this.bottomScale;
                float[] fArray23 = v[4];
                fArray23[1] = fArray23[1] - this.bottomScale;
                float[] fArray24 = v[5];
                fArray24[0] = fArray24[0] + (float)m * this.bottomScale;
                float[] fArray25 = v[5];
                fArray25[1] = fArray25[1] - this.bottomScale;
                float[] fArray26 = v[6];
                fArray26[0] = fArray26[0] + (float)m * this.bottomScale;
                float[] fArray27 = v[6];
                fArray27[1] = fArray27[1] + this.bottomScale;
                float[] fArray28 = v[7];
                fArray28[0] = fArray28[0] - (float)m * this.bottomScale;
                float[] fArray29 = v[7];
                fArray29[1] = fArray29[1] + this.bottomScale;
                break;
            }
            case 4: {
                float[] fArray = v[0];
                fArray[0] = fArray[0] - (float)m * this.bottomScale;
                float[] fArray30 = v[0];
                fArray30[2] = fArray30[2] - this.bottomScale;
                float[] fArray31 = v[1];
                fArray31[0] = fArray31[0] + (float)m * this.bottomScale;
                float[] fArray32 = v[1];
                fArray32[2] = fArray32[2] - this.bottomScale;
                float[] fArray33 = v[4];
                fArray33[0] = fArray33[0] - (float)m * this.bottomScale;
                float[] fArray34 = v[4];
                fArray34[2] = fArray34[2] + this.bottomScale;
                float[] fArray35 = v[5];
                fArray35[0] = fArray35[0] + (float)m * this.bottomScale;
                float[] fArray36 = v[5];
                fArray36[2] = fArray36[2] + this.bottomScale;
                break;
            }
            case 5: {
                float[] fArray = v[2];
                fArray[0] = fArray[0] + (float)m * this.bottomScale;
                float[] fArray37 = v[2];
                fArray37[2] = fArray37[2] - this.bottomScale;
                float[] fArray38 = v[3];
                fArray38[0] = fArray38[0] - (float)m * this.bottomScale;
                float[] fArray39 = v[3];
                fArray39[2] = fArray39[2] - this.bottomScale;
                float[] fArray40 = v[6];
                fArray40[0] = fArray40[0] + (float)m * this.bottomScale;
                float[] fArray41 = v[6];
                fArray41[2] = fArray41[2] + this.bottomScale;
                float[] fArray42 = v[7];
                fArray42[0] = fArray42[0] - (float)m * this.bottomScale;
                float[] fArray43 = v[7];
                fArray43[2] = fArray43[2] + this.bottomScale;
            }
        }
        return v;
    }

    private ArrayList setupVertices(float[][] v, arc centerVec) {
        ArrayList<NMTVertex[][]> verts = new ArrayList<NMTVertex[][]>();
        block5: for (int idx = 0; idx < 6; ++idx) {
            switch (idx) {
                case 0: 
                case 1: {
                    verts.add(new NMTVertex[this.xSub + 1][this.ySub + 1]);
                    continue block5;
                }
                case 2: 
                case 3: {
                    verts.add(new NMTVertex[this.zSub + 1][this.ySub + 1]);
                    continue block5;
                }
                case 4: 
                case 5: {
                    verts.add(new NMTVertex[this.xSub + 1][this.zSub + 1]);
                }
            }
        }
        for (int idz = 0; idz < this.zSub + 1; ++idz) {
            for (int idy = 0; idy < this.ySub + 1; ++idy) {
                for (int idx = 0; idx < this.xSub + 1; ++idx) {
                    if (idx > 0 && idx < this.xSub && idy > 0 && idy < this.ySub && idz > 0 && idz < this.zSub) continue;
                    float xS = (float)idx / (float)this.xSub;
                    float yS = (float)idy / (float)this.ySub;
                    float zS = (float)idz / (float)this.zSub;
                    float xCur = this.calculatePoint(v, 0, xS, yS, zS);
                    float yCur = this.calculatePoint(v, 1, xS, yS, zS);
                    float zCur = this.calculatePoint(v, 2, xS, yS, zS);
                    NMTVertex vert = new NMTVertex(xCur, yCur, zCur);
                    if (this.smooth) {
                        this.setNormalFromOrigin(vert, centerVec);
                    }
                    this.vertices.add(vert);
                    if (idx == 0) {
                        ((NMTVertex[][])verts.get((int)3))[this.zSub - idz][idy] = vert;
                    }
                    if (idx == this.xSub) {
                        ((NMTVertex[][])verts.get((int)2))[idz][idy] = vert;
                    }
                    if (idy == 0) {
                        ((NMTVertex[][])verts.get((int)4))[this.xSub - idx][idz] = vert;
                    }
                    if (idy == this.ySub) {
                        ((NMTVertex[][])verts.get((int)5))[idx][idz] = vert;
                    }
                    if (idz == 0) {
                        ((NMTVertex[][])verts.get((int)0))[idx][idy] = vert;
                    }
                    if (idz != this.zSub) continue;
                    ((NMTVertex[][])verts.get((int)1))[this.xSub - idx][idy] = vert;
                }
            }
        }
        return verts;
    }

    private void addQuadSet(NMTVertex[][] verts, int xSeg, int ySeg, float u1, float v1, float u2, float v2) {
        for (int idy = 0; idy < ySeg; ++idy) {
            for (int idx = 0; idx < xSeg; ++idx) {
                float uS1 = u1 + (u2 - u1) * ((float)idx / (float)xSeg) + 0.015625f;
                float vS1 = v1 + (v2 - v1) * ((float)idy / (float)ySeg) + 0.015625f;
                float uS2 = u1 + (u2 - u1) * ((float)(idx + 1) / (float)xSeg) - 0.015625f;
                float vS2 = v1 + (v2 - v1) * ((float)(idy + 1) / (float)ySeg) - 0.015625f;
                ArrayList<NMTVertex> nVert = new ArrayList<NMTVertex>();
                nVert.add(verts[idx + 1][idy]);
                nVert.add(verts[idx][idy]);
                nVert.add(verts[idx][idy + 1]);
                nVert.add(verts[idx + 1][idy + 1]);
                this.addQuad(nVert, 0, 1, 2, 3, uS1, vS1, uS2, vS2);
            }
        }
    }

    private float calculatePoint(float[][] v, int point, float aS, float bS, float cS) {
        float xD1 = (v[3][point] - v[0][point]) * bS + v[0][point];
        float xD2 = (v[2][point] - v[1][point]) * bS + v[1][point];
        float xD3 = (xD2 - xD1) * aS + xD1;
        float xD4 = (v[7][point] - v[4][point]) * bS + v[4][point];
        float xD5 = (v[6][point] - v[5][point]) * bS + v[5][point];
        float xD6 = (xD5 - xD4) * aS + xD4;
        float xD7 = (xD6 - xD3) * cS + xD3;
        return xD7;
    }
}

