/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTMaterial;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import java.util.ArrayList;
import java.util.Arrays;

public class NMTPolygon {
    public ArrayList vertices;
    public arc normal;
    public boolean invertNormal;
    public boolean recalcNormal;
    public boolean indivNormal;
    public boolean fromOrigNormal;
    public boolean textured;
    public NMTMaterial material;

    public NMTPolygon(ArrayList verts, arc vec) {
        this.vertices = verts;
        this.normal = vec;
        this.invertNormal = false;
        this.recalcNormal = true;
        this.indivNormal = false;
        this.fromOrigNormal = false;
        this.textured = true;
        this.material = null;
    }

    public NMTPolygon(ArrayList verts) {
        this(verts, null);
    }

    public NMTPolygon(NMTTextureVertex[] verts) {
        this(new ArrayList<NMTTextureVertex>(Arrays.asList(verts)));
    }

    public void flipFace() {
        ArrayList tempVerts = new ArrayList();
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            tempVerts.add(this.vertices.get(this.vertices.size() - (idx + 1)));
        }
        this.vertices.clear();
        this.vertices = tempVerts;
    }

    public void setNormal(float x, float y, float z) {
        this.normal = arc.a((double)x, (double)y, (double)z);
    }

    public void setMaterial(NMTMaterial mat) {
        this.material = mat;
    }

    public void draw(bge tessellator, float scale) {
        this.draw(tessellator, scale, false);
    }

    public void draw(bge tessellator, float scale, boolean disableTexture) {
        if (this.material != null) {
            this.material.setMaterial();
        }
        if (this.normal == null || this.recalcNormal) {
            arc vec3d = ((NMTTextureVertex)this.vertices.get((int)1)).vertex.transformVector.a(((NMTTextureVertex)this.vertices.get((int)0)).vertex.transformVector);
            arc vec3d1 = ((NMTTextureVertex)this.vertices.get((int)1)).vertex.transformVector.a(((NMTTextureVertex)this.vertices.get((int)2)).vertex.transformVector);
            this.normal = vec3d1.c(vec3d).a();
        }
        if (this.vertices.size() == 4) {
            tessellator.b();
        } else if (this.vertices.size() == 3) {
            tessellator.b(4);
        } else {
            tessellator.b(9);
        }
        if (this.invertNormal) {
            this.normal.c = -this.normal.c;
            this.normal.d = -this.normal.d;
            this.normal.e = -this.normal.e;
        }
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            NMTTextureVertex vertex = (NMTTextureVertex)this.vertices.get(idx);
            if (this.fromOrigNormal) {
                arc vec3d2 = arc.a((double)vertex.vertex.transformVector.c, (double)vertex.vertex.transformVector.d, (double)vertex.vertex.transformVector.e);
                vec3d2.a();
                if (this.invertNormal) {
                    vec3d2.c = -vec3d2.c;
                    vec3d2.d = -vec3d2.d;
                    vec3d2.e = -vec3d2.e;
                }
                tessellator.b((float)vec3d2.c, (float)vec3d2.d, (float)vec3d2.e);
            } else if (!this.indivNormal || vertex.normal == null && vertex.vertex.normal == null) {
                tessellator.b((float)this.normal.c, (float)this.normal.d, (float)this.normal.e);
            } else {
                arc useNormal = vertex.normal;
                if (useNormal == null) {
                    useNormal = vertex.vertex.normal;
                }
                if (this.invertNormal) {
                    tessellator.b(-((float)useNormal.c), -((float)useNormal.d), -((float)useNormal.e));
                } else {
                    tessellator.b((float)useNormal.c, (float)useNormal.d, (float)useNormal.e);
                }
            }
            if (disableTexture || !this.textured) {
                tessellator.a((double)((float)vertex.vertex.transformVector.c * scale), (double)((float)vertex.vertex.transformVector.d * scale), (double)((float)vertex.vertex.transformVector.e * scale));
                continue;
            }
            tessellator.a((double)((float)vertex.vertex.transformVector.c * scale), (double)((float)vertex.vertex.transformVector.d * scale), (double)((float)vertex.vertex.transformVector.e * scale), (double)vertex.textureU, (double)vertex.textureV);
        }
        tessellator.a();
        if (this.material != null) {
            this.material.resetMaterial();
        }
    }
}

