/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTTransformation;
import java.util.ArrayList;

public class NMTVertex {
    public arc baseVector;
    public arc transformVector;
    public ArrayList transformations;
    public arc baseNormal;
    public arc normal;

    public NMTVertex(float x, float y, float z) {
        this(arc.a((double)x, (double)y, (double)z));
    }

    public NMTVertex(arc vector) {
        this.baseVector = vector;
        this.transformVector = arc.a((double)this.baseVector.c, (double)this.baseVector.d, (double)this.baseVector.e);
        this.transformations = new ArrayList();
        this.baseNormal = null;
        this.normal = null;
    }

    public NMTVertex copyVertex() {
        NMTVertex vert = new NMTVertex((float)this.baseVector.c, (float)this.baseVector.d, (float)this.baseVector.e);
        if (this.normal != null) {
            vert.setNormals(arc.a((double)this.baseNormal.c, (double)this.baseNormal.d, (double)this.baseNormal.e));
        }
        return vert;
    }

    public void addTransformation(NMTTransformation transformation) {
        this.transformations.add(transformation);
    }

    public void setNormals(arc n) {
        this.normal = n;
        this.baseNormal = arc.a((double)n.c, (double)n.d, (double)n.e);
    }

    public void applyTransformations() {
        this.transformVector.c = this.baseVector.c;
        this.transformVector.d = this.baseVector.d;
        this.transformVector.e = this.baseVector.e;
        this.normal.c = this.baseNormal.c;
        this.normal.d = this.baseNormal.d;
        this.normal.e = this.baseNormal.e;
        float weight = 0.0f;
        float totalWeight = 0.0f;
        for (int idx = 0; idx < this.transformations.size(); ++idx) {
            NMTVertex tempVert = this.copyVertex();
            weight = ((NMTTransformation)this.transformations.get((int)idx)).weight;
            totalWeight += weight;
            tempVert = ((NMTTransformation)this.transformations.get(idx)).doTransformation(tempVert);
            this.transformVector.c += tempVert.transformVector.c * (double)weight;
            this.transformVector.d += tempVert.transformVector.d * (double)weight;
            this.transformVector.e += tempVert.transformVector.e * (double)weight;
            this.normal.c = tempVert.normal.c * (double)weight;
            this.normal.d = tempVert.normal.d * (double)weight;
            this.normal.e = tempVert.normal.e * (double)weight;
        }
        this.transformVector.c /= (double)totalWeight;
        this.transformVector.d /= (double)totalWeight;
        this.transformVector.e /= (double)totalWeight;
        this.normal.c /= (double)totalWeight;
        this.normal.d /= (double)totalWeight;
        this.normal.e /= (double)totalWeight;
    }

    public boolean equals(NMTVertex vertex) {
        if (vertex == this) {
            return true;
        }
        if (vertex == null) {
            return false;
        }
        return this.baseVector.c == vertex.baseVector.c && this.baseVector.d == vertex.baseVector.d && this.baseVector.e == vertex.baseVector.e;
    }
}

