/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.api.IMissile;
import icbm.api.IMissileLockable;
import icbm.api.RadarRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.API.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEntityLaunchFlameFX;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEntityLaunchSmokeFX;
import micdoodle8.mods.galacticraft.core.entities.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.moon.GCMoonConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreEntityRocketT1
extends EntitySpaceshipBase
implements lt,
IMissileLockable {
    private final int tankCapacity = 2000;
    public LiquidTank spaceshipFuelTank = new LiquidTank(this.tankCapacity);
    protected wm[] cargoItems = new wm[27];
    public gy rocketSoundUpdater;
    private int type;
    private GCCoreTileEntityLandingPad landingPad;
    public int canisterToTankRatio = this.tankCapacity / GCCoreItems.fuelCanister.n();
    public double canisterToLiquidStackRatio = 2000.0 / (double)GCCoreItems.fuelCanister.n();

    public GCCoreEntityRocketT1(aab par1World) {
        super(par1World);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.spaceshipFuelTank.getLiquid() == null ? 0.0 : (double)this.spaceshipFuelTank.getLiquid().amount;
        return (int)(fuelLevel * (double)i / 2000.0);
    }

    public GCCoreEntityRocketT1(aab par1World, double par2, double par4, double par6, int type) {
        super(par1World);
        this.b(par2, par4 + (double)this.N, par6);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.r = par2;
        this.s = par4;
        this.t = par6;
    }

    public GCCoreEntityRocketT1(aab par1World, double par2, double par4, double par6, boolean reversed, int type, wm[] inv) {
        this(par1World, par2, par4, par6, type);
        this.cargoItems = inv;
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(25, (Object)new Integer(0));
        this.setSpaceshipType(this.type);
        RadarRegistry.register(this);
    }

    @Override
    public void w() {
        super.w();
        RadarRegistry.unregister(this);
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.a();
        }
    }

    @Override
    public void l_() {
        super.l_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() == 1 || this.ab.nextInt(i) == 0) && !GCCoreConfigManager.disableSpaceshipParticles && this.hasFuelTank() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles(this.getLaunched() == 1);
        }
        if (this.rocketSoundUpdater != null && (this.ignite == 1 || this.getLaunched() == 1)) {
            this.rocketSoundUpdater.a();
        }
        if (this.launched && this.hasFuelTank()) {
            double d = this.timeSinceLaunch / 250.0f;
            if ((d = Math.min(d, 1.0)) != 0.0) {
                this.y = -d * Math.cos((double)(this.B - 180.0f) * Math.PI / 180.0);
            }
            double multiplier = 1.0;
            if (this.q.t instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.q.t).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)kx.c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(null, 1);
            }
        } else if (!this.hasFuelTank() && this.getLaunched() == 1 && !this.q.I && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.y -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        if (!this.q.I && this.ticks % 3L == 0L) {
            PacketManager.sendPacketToClients(this.getDescriptionPacket(), this.q, new Vector3(this), 50.0);
        }
    }

    public ei getDescriptionPacket() {
        ei p = GCCorePacketManager.getPacket("GCCoreEntities", (mp)this, new Object[]{this.spaceshipFuelTank.getLiquid() == null ? 0 : this.spaceshipFuelTank.getLiquid().amount, this.launched, this.ignite});
        return p;
    }

    @Override
    public void handlePacketData(cg network, int packetType, dk packet, sq player, ByteArrayDataInput dataStream) {
        try {
            if (this.q.I) {
                this.spaceshipFuelTank.setLiquid(new LiquidStack(GCCoreItems.fuel.cp, dataStream.readInt(), 0));
                this.launched = dataStream.readBoolean();
                this.ignite = dataStream.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasFuelTank() {
        return this.spaceshipFuelTank.getLiquid() != null && this.spaceshipFuelTank.getLiquid().amount != 0;
    }

    @Override
    public void onLaunch() {
    }

    @Override
    public void onTeleport(jc player) {
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((sq)player);
        player.a.b((ei)PacketUtil.createPacket("GalacticraftCore", 22, new Object[]{0}));
        if (playerBase != null) {
            playerBase.rocketStacks = this.cargoItems;
            playerBase.rocketType = this.getSpaceshipType();
            int liquid = this.spaceshipFuelTank.getLiquid() == null ? 0 : this.spaceshipFuelTank.getLiquid().amount / kx.c((double)(this.canisterToLiquidStackRatio == 0.0 ? 1.0 : this.canisterToLiquidStackRatio));
            playerBase.fuelDamage = Math.max(Math.min(GCCoreItems.fuelCanister.n() - liquid, GCCoreItems.fuelCanister.n()), 1);
        }
    }

    protected void spawnParticles(boolean launched) {
        double x1 = 2.0 * Math.cos((double)this.A * Math.PI / 180.0) * Math.sin((double)this.B * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.A * Math.PI / 180.0) * Math.sin((double)this.B * Math.PI / 180.0);
        double y1 = 2.0 * Math.cos((double)(this.B - 180.0f) * Math.PI / 180.0) + (this.getReversed() == 1 ? 10.0 : 0.0);
        if (this.getLaunched() == 0) {
            y1 -= 2.0;
        }
        double y = this.s + (this.v - this.s);
        if (!this.M) {
            this.spawnParticle("launchflame", this.u + 0.4 - this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w + 0.4 - this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u - 0.4 + this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w + 0.4 - this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u - 0.4 + this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w - 0.4 + this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u + 0.4 - this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w - 0.4 + this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u + 0.4 + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u - 0.4 + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w + 0.4 + z1, x1, y1, z1, this.getLaunched() == 1);
            this.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w - 0.4 + z1, x1, y1, z1, this.getLaunched() == 1);
        }
    }

    public boolean a(sq par1EntityPlayer) {
        return this.M ? false : par1EntityPlayer.e((mp)this) <= 64.0;
    }

    public int j_() {
        return 27;
    }

    @Override
    protected void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("Type", this.getSpaceshipType());
        if (this.j_() > 0) {
            ca var2 = new ca();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                bs var4 = new bs();
                var4.a("Slot", (byte)var3);
                this.cargoItems[var3].b(var4);
                var2.a((cf)var4);
            }
            par1NBTTagCompound.a("Items", (cf)var2);
        }
        if (this.spaceshipFuelTank.getLiquid() != null) {
            par1NBTTagCompound.a("fuelTank", (cf)this.spaceshipFuelTank.writeToNBT(new bs()));
        }
    }

    @Override
    protected void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.setSpaceshipType(par1NBTTagCompound.e("Type"));
        if (this.j_() > 0) {
            ca var2 = par1NBTTagCompound.m("Items");
            this.cargoItems = new wm[this.j_()];
            for (int var3 = 0; var3 < var2.c(); ++var3) {
                bs var4 = (bs)var2.b(var3);
                int var5 = var4.c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = wm.a((bs)var4);
            }
        }
        if (par1NBTTagCompound.b("fuelTank")) {
            this.spaceshipFuelTank.readFromNBT(par1NBTTagCompound.l("fuelTank"));
        }
    }

    public wm a(int par1) {
        return this.cargoItems[par1];
    }

    public wm a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].a <= par2) {
                wm var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            wm var3 = this.cargoItems[par1].a(par2);
            if (this.cargoItems[par1].a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public wm b(int par1) {
        if (this.cargoItems[par1] != null) {
            wm var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, wm par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.d()) {
            par2ItemStack.a = this.d();
        }
    }

    public void setSpaceshipType(int par1) {
        this.ah.b(25, (Object)par1);
    }

    public int getSpaceshipType() {
        return this.ah.c(25);
    }

    public String b() {
        return "container.spaceship";
    }

    public int d() {
        return 64;
    }

    public void k_() {
    }

    public void f() {
    }

    public void g() {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12, boolean b) {
        this.spawnParticle(var1, var2, var4, var6, var8, var10, var12, 0.0, 0.0, 0.0, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12, double var13, double var14, double var15, boolean b) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.h != null && mc.j != null) {
            bez fx;
            double var16 = mc.h.u - var2;
            double var17 = mc.h.v - var4;
            double var19 = mc.h.w - var6;
            Object var21 = null;
            double var22 = 64.0;
            if (var1.equals("whitesmoke")) {
                GCCoreEntityLaunchSmokeFX fx2 = new GCCoreEntityLaunchSmokeFX((aab)mc.e, var2, var4, var6, var8, var10, var12, 1.0f, b);
                if (fx2 != null) {
                    mc.j.a((beu)fx2);
                }
            } else if (var1.equals("whitesmokelarge")) {
                GCCoreEntityLaunchSmokeFX fx3 = new GCCoreEntityLaunchSmokeFX((aab)mc.e, var2, var4, var6, var8, var10, var12, 2.5f, b);
                if (fx3 != null) {
                    mc.j.a((beu)fx3);
                }
            } else if (var1.equals("launchflame")) {
                GCCoreEntityLaunchFlameFX fx4 = new GCCoreEntityLaunchFlameFX((aab)mc.e, var2, var4, var6, var8, var10, var12, 1.0f);
                if (fx4 != null) {
                    mc.j.a((beu)fx4);
                }
            } else if (var1.equals("distancesmoke") && var16 * var16 + var17 * var17 + var19 * var19 < 6963.2 && (fx = new bez((aab)mc.e, var2, var4, var6, var8, var10, var12, 2.5f)) != null) {
                mc.j.a((beu)fx);
            }
        }
    }

    @Override
    public mp[] getSpaceshipParts() {
        return null;
    }

    @Override
    public HashSet getPossiblePlanets() {
        HashSet<Integer> dimensions = new HashSet<Integer>();
        dimensions.add(0);
        dimensions.add(GCMoonConfigManager.dimensionIDMoon);
        return dimensions;
    }

    @Override
    public int getPreLaunchWait() {
        return 400;
    }

    @Override
    public List getItemsDropped() {
        ArrayList<wm> items = new ArrayList<wm>();
        items.add(new wm(GCCoreItems.spaceship, 1, this.getSpaceshipType()));
        for (wm item : this.cargoItems) {
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public boolean c() {
        return false;
    }

    public boolean b(int i, wm itemstack) {
        return false;
    }

    @Override
    public int getMaxFuel() {
        return this.spaceshipFuelTank.getCapacity();
    }

    @Override
    public boolean canLock(IMissile missile) {
        return true;
    }

    @Override
    public Vector3 getPredictedPosition(int ticks) {
        return new Vector3(this);
    }

    @Override
    public int addFuel(LiquidStack liquid, int amount, boolean doFill) {
        LiquidStack liquidInTank = this.spaceshipFuelTank.getLiquid();
        if (liquid != null && LiquidDictionary.findLiquidName((LiquidStack)liquid).equals("Fuel") && (liquidInTank == null || liquidInTank.amount + liquid.amount <= this.spaceshipFuelTank.getCapacity())) {
            return this.spaceshipFuelTank.fill(liquid, doFill);
        }
        return 0;
    }

    @Override
    public LiquidStack removeFuel(LiquidStack liquid, int amount) {
        if (liquid == null) {
            return this.spaceshipFuelTank.drain(amount, true);
        }
        return null;
    }

    @Override
    public void onPadDestroyed() {
        if (!this.M && !this.launched) {
            this.dropShipAsItem();
            this.w();
        }
    }

    @Override
    public void setLandingPad(GCCoreTileEntityLandingPad pad) {
        this.landingPad = pad;
    }

    @Override
    public GCCoreTileEntityLandingPad getLandingPad() {
        return this.landingPad;
    }
}

