/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import mekanism.api.EnumGas;
import mekanism.api.IGasAcceptor;
import mekanism.api.ITubeConnection;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCompressor;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreTileEntityOxygen
extends GCCoreTileEntityElectric
implements IGasAcceptor,
ITubeConnection {
    public int maxOxygen;
    public int oxygenPerTick;
    public int storedOxygen;
    public int lastStoredOxygen;
    public static int timeSinceOxygenRequest;

    public GCCoreTileEntityOxygen(int ueWattsPerTick, double ic2MaxEnergy, double bcEnergyPerTick, double ic2EnergyPerTick, int maxOxygen, int oxygenPerTick) {
        super(ueWattsPerTick, ic2MaxEnergy, ic2EnergyPerTick, bcEnergyPerTick);
        this.maxOxygen = maxOxygen;
        this.oxygenPerTick = oxygenPerTick;
    }

    public abstract ForgeDirection getOxygenInputDirection();

    public abstract boolean shouldPullOxygen();

    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor((double)this.storedOxygen / (double)this.maxOxygen * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I) {
            if (GCCoreTileEntityOxygenCompressor.timeSinceOxygenRequest > 0) {
                --GCCoreTileEntityOxygenCompressor.timeSinceOxygenRequest;
            }
            this.oxygenPerTick = (int)((float)this.storedOxygen / 250.0f);
            if (this.storedOxygen == this.lastStoredOxygen && this.storedOxygen < 250) {
                this.oxygenPerTick = 1;
            }
            this.storedOxygen = Math.max(this.storedOxygen - this.oxygenPerTick, 0);
        }
        this.lastStoredOxygen = this.storedOxygen;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return side == this.getOxygenInputDirection() && type == EnumGas.OXYGEN;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection direction) {
        return direction == this.getOxygenInputDirection();
    }

    @Override
    public int transferGasToAcceptor(int amount, EnumGas type) {
        timeSinceOxygenRequest = 20;
        if (this.shouldPullOxygen() && type == EnumGas.OXYGEN) {
            int rejectedOxygen = 0;
            int requiredOxygen = this.maxOxygen - this.storedOxygen;
            if (amount <= requiredOxygen) {
                this.storedOxygen += amount;
            } else {
                this.storedOxygen += requiredOxygen;
                rejectedOxygen = amount - requiredOxygen;
            }
            return rejectedOxygen;
        }
        return amount;
    }

    @Override
    public void a(bs nbt) {
        super.a(nbt);
        this.storedOxygen = nbt.e("storedOxygen");
    }

    @Override
    public void b(bs nbt) {
        super.b(nbt);
        nbt.a("storedOxygen", this.storedOxygen);
    }
}

