/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.moon.blocks.GCMoonBlocks;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonRoom;

public class GCMapGenDungeon {
    public static final int DUNGEON_WALL_ID = GCMoonBlocks.blockMoon.cz;
    public static final int DUNGEON_WALL_META = 14;
    public static final int RANGE = 8;
    public static final int HALLWAY_LENGTH = 16;
    public static final int HALLWAY_HEIGHT = 3;
    public static boolean useArrays = false;
    public aab worldObj;
    private ArrayList rooms = new ArrayList();

    public void generateUsingArrays(aab world, long seed, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas) {
        t dungeonCoords = this.getDungeonNear(seed, chunkX, chunkZ);
        if (dungeonCoords != null) {
            this.generate(world, new Random(seed * (long)dungeonCoords.a * (long)dungeonCoords.c * 24789L), dungeonCoords.a, y, dungeonCoords.c, chunkX, chunkZ, blocks, metas, true);
        }
    }

    public void generateUsingSetBlock(aab world, int x, int y, int z) {
        this.generate(world, new Random(this.worldObj.L().b() * (long)x * (long)z * 24789L), x, y, z, x, z, null, null, false);
    }

    public void generate(aab world, Random rand, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas, boolean useArrays) {
        GCMapGenDungeon.useArrays = useArrays;
        this.worldObj = world;
        ArrayList<GCDungeonBoundingBox> boundingBoxes = new ArrayList<GCDungeonBoundingBox>();
        int length = rand.nextInt(4) + 5;
        GCDungeonRoom currentRoom = GCDungeonRoom.makeRoom(this.worldObj, rand, x, y, z, 4);
        currentRoom.generate(blocks, metas, chunkX, chunkZ);
        this.rooms.add(currentRoom);
        block18: for (int i = 0; i <= length; ++i) {
            for (int j = 0; j < 6; ++j) {
                GCDungeonBoundingBox corridor1;
                int dir;
                int offsetX = 0;
                int offsetZ = 0;
                int entranceDir = dir = this.randDir(rand, currentRoom.entranceDir);
                switch (dir) {
                    case 0: {
                        offsetZ = 16 + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 1;
                            offsetX = 16 + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 2;
                        offsetX = -16 - rand.nextInt(15);
                        break;
                    }
                    case 1: {
                        offsetX = 16 + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 0;
                            offsetZ = 16 + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 3;
                        offsetZ = -16 - rand.nextInt(15);
                        break;
                    }
                    case 2: {
                        offsetX = -16 - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 0;
                            offsetZ = 16 + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 3;
                        offsetZ = -16 - rand.nextInt(15);
                        break;
                    }
                    case 3: {
                        offsetZ = -16 - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 1;
                            offsetX = 16 + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 2;
                        offsetX = -16 - rand.nextInt(15);
                        break;
                    }
                }
                GCDungeonRoom possibleRoom = GCDungeonRoom.makeRoom(this.worldObj, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                if (i == length - 1) {
                    possibleRoom = GCDungeonRoom.makeBossRoom(this.worldObj, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                }
                if (i == length) {
                    possibleRoom = GCDungeonRoom.makeTreasureRoom(this.worldObj, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                }
                GCDungeonBoundingBox possibleRoomBb = possibleRoom.getBoundingBox();
                GCDungeonBoundingBox currentRoomBb = currentRoom.getBoundingBox();
                if (this.isIntersecting(possibleRoomBb, boundingBoxes)) continue;
                int cx = (currentRoomBb.minX + currentRoomBb.maxX) / 2;
                int cz = (currentRoomBb.minZ + currentRoomBb.maxZ) / 2;
                int px = (possibleRoomBb.minX + possibleRoomBb.maxX) / 2;
                int pz = (possibleRoomBb.minZ + possibleRoomBb.maxZ) / 2;
                int ax = (cx + px) / 2;
                int az = (cz + pz) / 2;
                if (offsetX == 0 || offsetZ == 0) {
                    corridor1 = null;
                    switch (dir) {
                        case 0: {
                            corridor1 = new GCDungeonBoundingBox(ax - 1, currentRoomBb.maxZ, ax, possibleRoomBb.minZ - 1);
                            break;
                        }
                        case 1: {
                            corridor1 = new GCDungeonBoundingBox(currentRoomBb.maxX, az - 1, possibleRoomBb.minX - 1, az);
                            break;
                        }
                        case 2: {
                            corridor1 = new GCDungeonBoundingBox(possibleRoomBb.maxX, az - 1, currentRoomBb.minX - 1, az);
                            break;
                        }
                        case 3: {
                            corridor1 = new GCDungeonBoundingBox(ax - 1, possibleRoomBb.maxZ, ax, currentRoomBb.minZ - 1);
                            break;
                        }
                    }
                    if (this.isIntersecting(corridor1, boundingBoxes)) continue;
                    boundingBoxes.add(possibleRoomBb);
                    boundingBoxes.add(corridor1);
                    currentRoom = possibleRoom;
                    currentRoom.generate(blocks, metas, chunkX, chunkZ);
                    this.rooms.add(currentRoom);
                    if (corridor1 == null) continue block18;
                    this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                    continue block18;
                }
                corridor1 = null;
                GCDungeonBoundingBox corridor2 = null;
                int dir2 = 0;
                int extraLength = 0;
                if (rand.nextInt(6) == 0) {
                    extraLength = rand.nextInt(7);
                }
                switch (dir) {
                    case 0: {
                        corridor1 = new GCDungeonBoundingBox(cx - 1, currentRoomBb.maxZ, cx + 1, pz - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCDungeonBoundingBox(corridor1.minX - extraLength, corridor1.maxZ + 1, possibleRoomBb.minX, corridor1.maxZ + 3);
                            dir2 = 1;
                            break;
                        }
                        corridor2 = new GCDungeonBoundingBox(possibleRoomBb.maxX, corridor1.maxZ + 1, corridor1.maxX + extraLength, corridor1.maxZ + 3);
                        dir2 = 2;
                        break;
                    }
                    case 1: {
                        corridor1 = new GCDungeonBoundingBox(currentRoomBb.maxX, cz - 1, px - 1, cz + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCDungeonBoundingBox(corridor1.maxX + 1, corridor1.minZ - extraLength, corridor1.maxX + 4, possibleRoomBb.minZ);
                            dir2 = 0;
                            break;
                        }
                        corridor2 = new GCDungeonBoundingBox(corridor1.maxX + 1, possibleRoomBb.maxZ, corridor1.maxX + 4, corridor1.maxZ + extraLength);
                        dir2 = 3;
                        break;
                    }
                    case 2: {
                        corridor1 = new GCDungeonBoundingBox(px + 1, cz - 1, currentRoomBb.minX - 1, cz + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCDungeonBoundingBox(corridor1.minX - 3, corridor1.minZ - extraLength, corridor1.minX - 1, possibleRoomBb.minZ);
                            dir2 = 0;
                            break;
                        }
                        corridor2 = new GCDungeonBoundingBox(corridor1.minX - 3, possibleRoomBb.maxZ, corridor1.minX - 1, corridor1.maxZ + extraLength);
                        dir2 = 3;
                        break;
                    }
                    case 3: {
                        corridor1 = new GCDungeonBoundingBox(cx - 1, pz + 1, cx + 1, currentRoomBb.minZ - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCDungeonBoundingBox(corridor1.minX - extraLength, corridor1.minZ - 3, possibleRoomBb.minX, corridor1.minZ - 1);
                            dir2 = 1;
                            break;
                        }
                        corridor2 = new GCDungeonBoundingBox(possibleRoomBb.maxX, corridor1.minZ - 3, corridor1.maxX + extraLength, corridor1.minZ - 1);
                        dir2 = 2;
                        break;
                    }
                }
                if (this.isIntersecting(corridor1, boundingBoxes) || this.isIntersecting(corridor2, boundingBoxes)) continue;
                boundingBoxes.add(possibleRoomBb);
                boundingBoxes.add(corridor1);
                boundingBoxes.add(corridor2);
                currentRoom = possibleRoom;
                currentRoom.generate(blocks, metas, chunkX, chunkZ);
                this.rooms.add(currentRoom);
                if (corridor1 == null || corridor2 == null) continue block18;
                this.genCorridor(corridor2, rand, possibleRoom.posY, chunkX, chunkZ, dir2, blocks, metas, true);
                this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                continue block18;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void genCorridor(GCDungeonBoundingBox corridor, Random rand, int y, int cx, int cz, int dir, short[] blocks, byte[] metas, boolean doubleCorridor) {
        int i = corridor.minX - 1;
        block6: while (i <= corridor.maxX + 1) {
            int k = corridor.minZ - 1;
            while (true) {
                if (k <= corridor.maxZ + 1) {
                } else {
                    ++i;
                    continue block6;
                }
                block8: for (int j = y - 1; j <= y + 3; ++j) {
                    boolean flag = false;
                    switch (dir) {
                        case 0: {
                            if (k == corridor.minZ - 1 && !doubleCorridor || k == corridor.maxZ + 1) break block8;
                            if (doubleCorridor && k == corridor.minZ - 1) {
                                flag = true;
                            }
                            if (i != corridor.minX - 1 && i != corridor.maxX + 1 && j != y - 1 && j != y + 3) break;
                            flag = true;
                            break;
                        }
                        case 3: {
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 && !doubleCorridor) break block8;
                            if (doubleCorridor && k == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (i != corridor.minX - 1 && i != corridor.maxX + 1 && j != y - 1 && j != y + 3) break;
                            flag = true;
                            break;
                        }
                        case 1: {
                            if (i == corridor.minX - 1 && !doubleCorridor || i == corridor.maxX + 1) break block8;
                            if (i == corridor.minX - 1) {
                                flag = true;
                            }
                            if (k != corridor.minZ - 1 && k != corridor.maxZ + 1 && j != y - 1 && j != y + 3) break;
                            flag = true;
                            break;
                        }
                        case 2: {
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 && !doubleCorridor) break block8;
                            if (i == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (k != corridor.minZ - 1 && k != corridor.maxZ + 1 && j != y - 1 && j != y + 3) break;
                            flag = true;
                        }
                    }
                    if (!flag) {
                        this.placeBlock(blocks, metas, i, j, k, cx, cz, 0, 0);
                        continue;
                    }
                    this.placeBlock(blocks, metas, i, j, k, cx, cz, DUNGEON_WALL_ID, 14);
                }
                if (rand.nextInt(50) == 0) {
                    this.placeBlock(blocks, metas, i, y - 1, k, cx, cz, apa.bh.cz, 0);
                }
                ++k;
            }
            break;
        }
        return;
    }

    public void handleTileEntities(Random rand) {
        ArrayList rooms = new ArrayList();
        rooms.addAll(this.rooms);
        for (GCDungeonRoom room : rooms) {
            room.handleTileEntities(rand);
        }
    }

    protected boolean canGenDungeonAtCoords(long worldSeed, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long dungeonSeed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldSeed + 4291726L;
        Random rand = new Random(dungeonSeed);
        randX *= numChunks;
        randZ *= numChunks;
        return oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks));
    }

    public t getDungeonNear(long worldSeed, int i, int j) {
        int range = 8;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                if (!this.canGenDungeonAtCoords(worldSeed, x, z)) continue;
                return new t(x * 16 + 8, 0, z * 16 + 8);
            }
        }
        return null;
    }

    private void placeBlock(short[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, int id, int meta) {
        if (useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = (short)id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.f(x, y, z, id, meta, 3);
        }
    }

    private int getOppositeDir(int dir) {
        switch (dir) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 5;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private int randDir(Random rand, int dir) {
        int[] dirHelper = new int[dir < 4 ? 3 : 4];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == dir) continue;
            dirHelper[k] = i;
            ++k;
        }
        return dirHelper[rand.nextInt(dirHelper.length)];
    }

    private boolean isIntersecting(GCDungeonBoundingBox bb, List dungeonBbs) {
        for (GCDungeonBoundingBox bb2 : dungeonBbs) {
            if (!bb.isOverlapping(bb2)) continue;
            return true;
        }
        return false;
    }
}

