/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.moon.blocks.GCMoonBlocks;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonRoom;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;

public class GCRoomBoss
extends GCDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    Random rand;
    t spawnerCoords;

    public GCRoomBoss(aab worldObj, int posX, int posY, int posZ, int entranceDir) {
        super(worldObj, posX, posY, posZ, entranceDir);
        if (worldObj != null) {
            this.rand = new Random(worldObj.F() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = this.rand.nextInt(6) + 14;
            this.sizeY = this.rand.nextInt(2) + 8;
            this.sizeZ = this.rand.nextInt(6) + 14;
        }
    }

    @Override
    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                boolean flag = this.rand.nextFloat() < 0.5f;
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GCMapGenDungeon.DUNGEON_WALL_ID, 14);
                        continue;
                    }
                    if (i == this.posX && k == this.posZ || i == this.posX + this.sizeX - 1 && k == this.posZ || i == this.posX && k == this.posZ + this.sizeZ - 1 || i == this.posX + this.sizeX - 1 && k == this.posZ + this.sizeZ - 1) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, apa.G.cz, 0);
                        continue;
                    }
                    if (j % 3 == 0 && j >= this.posY + 2 && (i == this.posX || i == this.posX + this.sizeX - 1 || k == this.posZ || k == this.posZ + this.sizeZ - 1) || i == this.posX + 1 && k == this.posZ || i == this.posX && k == this.posZ + 1 || i == this.posX + this.sizeX - 2 && k == this.posZ || i == this.posX + this.sizeX - 1 && k == this.posZ + 1 || i == this.posX + 1 && k == this.posZ + this.sizeZ - 1 || i == this.posX && k == this.posZ + this.sizeZ - 2 || i == this.posX + this.sizeX - 2 && k == this.posZ + this.sizeZ - 1 || i == this.posX + this.sizeX - 1 && k == this.posZ + this.sizeZ - 2) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, apa.bt.cz, 0);
                        continue;
                    }
                    if ((i == this.posX + 1 && k == this.posZ + 1 || i == this.posX + this.sizeX - 2 && k == this.posZ + 1 || i == this.posX + 1 && k == this.posZ + this.sizeZ - 2 || i == this.posX + this.sizeX - 2 && k == this.posZ + this.sizeZ - 2) && j % 3 == 0) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, apa.bt.cz, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        this.spawnerCoords = new t(hx, this.posY + 2, hz);
    }

    @Override
    public GCDungeonBoundingBox getBoundingBox() {
        return new GCDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GCDungeonRoom makeRoom(aab worldObj, int x, int y, int z, int dir) {
        return new GCRoomBoss(worldObj, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (this.spawnerCoords == null) {
            return;
        }
        this.worldObj.f(this.spawnerCoords.a, this.spawnerCoords.b, this.spawnerCoords.c, GCMoonBlocks.blockMoon.cz, 15, 3);
        aqp tile = this.worldObj.r(this.spawnerCoords.a, this.spawnerCoords.b, this.spawnerCoords.c);
        if (tile == null || !(tile instanceof GCCoreTileEntityDungeonSpawner)) {
            this.worldObj.a(this.spawnerCoords.a, this.spawnerCoords.b, this.spawnerCoords.c, (aqp)new GCCoreTileEntityDungeonSpawner());
        }
    }
}

