/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonRoom;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;

public class GCRoomSpawner
extends GCDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    Random rand;
    private ArrayList spawners = new ArrayList();

    public GCRoomSpawner(aab worldObj, int posX, int posY, int posZ, int entranceDir) {
        super(worldObj, posX, posY, posZ, entranceDir);
        if (worldObj != null) {
            this.rand = new Random(worldObj.F() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = this.rand.nextInt(5) + 6;
            this.sizeY = this.rand.nextInt(2) + 4;
            this.sizeZ = this.rand.nextInt(5) + 6;
        }
    }

    @Override
    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GCMapGenDungeon.DUNGEON_WALL_ID, 14);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                    if (!(this.rand.nextFloat() < 0.05f)) continue;
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, apa.aa.cz, 0);
                }
            }
        }
        if (this.placeBlock(chunk, meta, this.posX + 1, this.posY - 2, this.posZ + 1, cx, cz, apa.aw.cz, 0)) {
            this.spawners.add(new t(this.posX + 1, this.posY - 2, this.posZ + 1));
        }
        if (this.placeBlock(chunk, meta, this.posX + this.sizeX - 1, this.posY - 2, this.posZ + this.sizeZ - 1, cx, cz, apa.aw.cz, 0)) {
            this.spawners.add(new t(this.posX + this.sizeX - 1, this.posY - 2, this.posZ + this.sizeZ - 1));
        }
    }

    @Override
    public GCDungeonBoundingBox getBoundingBox() {
        return new GCDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GCDungeonRoom makeRoom(aab worldObj, int x, int y, int z, int dir) {
        return new GCRoomSpawner(worldObj, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        for (t spawnerCoords : this.spawners) {
            aqj spawner = (aqj)this.worldObj.r(spawnerCoords.a, spawnerCoords.b, spawnerCoords.c);
            if (spawner == null) continue;
            spawner.a().a(GCRoomSpawner.getMob(rand));
        }
    }

    private static String getMob(Random rand) {
        switch (rand.nextInt(2)) {
            case 0: {
                return "Evolved Spider";
            }
            case 1: {
                return "Evolved Skeleton";
            }
        }
        return "Evolved Zombie";
    }
}

