/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.item;

import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ElectricItemHelper {
    public static double chargeItem(wm itemStack, double joules, double voltage) {
        IItemElectric electricItem;
        double providingWatts;
        if (itemStack != null && itemStack.b() instanceof IItemElectric && (providingWatts = Math.min(joules, (electricItem = (IItemElectric)itemStack.b()).getReceiveRequest(itemStack).getWatts())) > 0.0) {
            ElectricityPack providedElectricity = electricItem.onReceive(ElectricityPack.getFromWatts(providingWatts, voltage), itemStack);
            return providedElectricity.getWatts();
        }
        return 0.0;
    }

    public static double dechargeItem(wm itemStack, double joules, double voltage) {
        IItemElectric electricItem;
        double requestingWatts;
        if (itemStack != null && itemStack.b() instanceof IItemElectric && (requestingWatts = Math.min(joules, (electricItem = (IItemElectric)itemStack.b()).getProvideRequest(itemStack).getWatts())) > 0.0) {
            ElectricityPack receivedElectricity = electricItem.onProvide(ElectricityPack.getFromWatts(requestingWatts, voltage), itemStack);
            return receivedElectricity.getWatts();
        }
        return 0.0;
    }

    public static wm getWithCharge(wm itemStack, double joules) {
        if (itemStack != null && itemStack.b() instanceof IItemElectric) {
            ((IItemElectric)itemStack.b()).setJoules(joules, itemStack);
            return itemStack;
        }
        return itemStack;
    }

    public static wm getWithCharge(wk item, double joules) {
        return ElectricItemHelper.getWithCharge(new wm(item), joules);
    }

    public static wm getCloneWithCharge(wm itemStack, double joules) {
        return ElectricItemHelper.getWithCharge(itemStack.m(), joules);
    }

    public static wm getUncharged(wm itemStack) {
        return ElectricItemHelper.getWithCharge(itemStack, 0.0);
    }

    public static wm getUncharged(wk item) {
        return ElectricItemHelper.getUncharged(new wm(item));
    }
}

