/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityConductor
extends TileEntityAdvanced
implements IConductor,
IPacketReceiver {
    private IElectricityNetwork network;
    public boolean[] visuallyConnected = new boolean[]{false, false, false, false, false, false};
    public aqp[] connectedBlocks = new aqp[]{null, null, null, null, null, null};
    protected String channel = "";

    public void updateConnection(aqp tileEntity, ForgeDirection side) {
        if (!this.k.I) {
            if (tileEntity instanceof IConnector && ((IConnector)tileEntity).canConnect(side.getOpposite())) {
                this.connectedBlocks[side.ordinal()] = tileEntity;
                this.visuallyConnected[side.ordinal()] = true;
                if (tileEntity.getClass() == this.getClass() && tileEntity instanceof INetworkProvider) {
                    this.getNetwork().mergeConnection(((INetworkProvider)tileEntity).getNetwork());
                }
                return;
            }
            if (this.connectedBlocks[side.ordinal()] != null) {
                this.getNetwork().stopProducing(this.connectedBlocks[side.ordinal()]);
                this.getNetwork().stopRequesting(this.connectedBlocks[side.ordinal()]);
            }
            this.connectedBlocks[side.ordinal()] = null;
            this.visuallyConnected[side.ordinal()] = false;
        }
    }

    @Override
    public void handlePacketData(cg network, int type, dk packet, sq player, ByteArrayDataInput dataStream) {
        if (this.k.I) {
            this.visuallyConnected[0] = dataStream.readBoolean();
            this.visuallyConnected[1] = dataStream.readBoolean();
            this.visuallyConnected[2] = dataStream.readBoolean();
            this.visuallyConnected[3] = dataStream.readBoolean();
            this.visuallyConnected[4] = dataStream.readBoolean();
            this.visuallyConnected[5] = dataStream.readBoolean();
        }
    }

    @Override
    public void initiate() {
        this.updateAdjacentConnections();
    }

    public void w_() {
        if (!this.k.I) {
            this.getNetwork().splitNetwork(this);
        }
        super.w_();
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I && this.ticks % 300L == 0L) {
            this.updateAdjacentConnections();
        }
    }

    @Override
    public void updateAdjacentConnections() {
        if (this.k != null && !this.k.I) {
            boolean[] previousConnections = (boolean[])this.visuallyConnected.clone();
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.updateConnection(VectorHelper.getConnectorFromSide(this.k, new Vector3(this), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
            }
            if (!Arrays.areEqual((boolean[])previousConnections, (boolean[])this.visuallyConnected)) {
                this.k.j(this.l, this.m, this.n);
            }
        }
    }

    public ei m() {
        return PacketManager.getPacket(this.channel, this, new Object[]{this.visuallyConnected[0], this.visuallyConnected[1], this.visuallyConnected[2], this.visuallyConnected[3], this.visuallyConnected[4], this.visuallyConnected[5]});
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            this.setNetwork(new ElectricityNetwork(this));
        }
        return this.network;
    }

    @Override
    public void setNetwork(IElectricityNetwork network) {
        this.network = network;
    }

    @Override
    public aqp[] getAdjacentConnections() {
        return this.connectedBlocks;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public aqx getRenderBoundingBox() {
        return aqx.a().a((double)this.l, (double)this.m, (double)this.n, (double)(this.l + 1), (double)(this.m + 1), (double)(this.n + 1));
    }
}

