/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.vector;

import java.util.ArrayList;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region2;

public class Region3 {
    public Vector3 min;
    public Vector3 max;

    public Region3() {
        this(new Vector3(), new Vector3());
    }

    public Region3(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Region3(aqx aabb) {
        this.min = new Vector3(aabb.a, aabb.b, aabb.c);
        this.max = new Vector3(aabb.d, aabb.e, aabb.f);
    }

    public aqx toAABB() {
        return aqx.a((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z);
    }

    public Region2 toRegion2() {
        return new Region2(this.min.toVector2(), this.max.toVector2());
    }

    public boolean isIn(Vector3 point) {
        return point.x > this.min.x && point.x < this.max.x && point.y > this.min.y && point.y < this.max.y && point.z > this.min.z && point.z < this.max.z;
    }

    public boolean isIn(Region3 region) {
        return region.max.x > this.min.x && region.min.x < this.max.x ? (region.max.y > this.min.y && region.min.y < this.max.y ? region.max.z > this.min.z && region.min.z < this.max.z : false) : false;
    }

    public void expand(Vector3 difference) {
        this.min.subtract(difference);
        this.max.add(difference);
    }

    public List getVectors() {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x2 = this.min.intX(); x2 < this.max.intX(); ++x2) {
            int y = this.min.intY();
            while (x2 < this.max.intY()) {
                int z2 = this.min.intZ();
                while (x2 < this.max.intZ()) {
                    vectors.add(new Vector3(x2, y, z2));
                    ++z2;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List getVectors(Vector3 center, int radius) {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x2 = this.min.intX(); x2 < this.max.intX(); ++x2) {
            int y = this.min.intY();
            while (x2 < this.max.intY()) {
                int z2 = this.min.intZ();
                while (x2 < this.max.intZ()) {
                    Vector3 vector3 = new Vector3(x2, y, z2);
                    if (center.distanceTo(vector3) <= (double)radius) {
                        vectors.add(vector3);
                    }
                    ++z2;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List getEntities(aab world, Class entityClass) {
        return world.a(entityClass, this.toAABB());
    }

    public List getEntitiesExlude(aab world, mp entity) {
        return world.b(entity, this.toAABB());
    }

    public List getEntities(aab world) {
        return this.getEntities(world, mp.class);
    }
}

