/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.Utils;
import thaumcraft.common.lib.events.ServerTickEventsFML;

public class ItemFocusTrade
extends ItemFocusBasic {
    public IIcon iconOrnament;
    private static final AspectList cost = new AspectList().add(Aspect.ENTROPY, 7).add(Aspect.ORDER, 7);

    public ItemFocusTrade() {
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "BT" + super.getSortingHelper(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:focus_trade");
        this.iconOrnament = ir.func_94245_a("thaumcraft:focus_trade_orn");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int renderPass) {
        return renderPass == 1 ? this.icon : this.iconOrnament;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public IIcon getOrnament() {
        return this.iconOrnament;
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            Block bi = world.func_147439_a(x, y, z);
            int md = world.func_72805_g(x, y, z);
            if (player.func_70093_af()) {
                if (!world.field_72995_K && world.func_147438_o(x, y, z) == null) {
                    ItemStack isout = new ItemStack(bi, 1, md);
                    try {
                        ItemStack is;
                        if (bi != Blocks.field_150350_a && (is = Utils.createStackedBlock(bi, md)) != null) {
                            isout = is.func_77946_l();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.storePickedBlock(itemstack, isout);
                } else {
                    player.func_71038_i();
                }
            } else {
                ItemStack pb = this.getPickedBlock(itemstack);
                if (pb != null && world.field_72995_K) {
                    player.func_71038_i();
                } else if (pb != null && world.func_147438_o(x, y, z) == null && world.func_147439_a(x, y, z).func_149688_o() != Config.taintMaterial) {
                    ServerTickEventsFML.addSwapper(world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), pb, 3 + wand.getFocusPotency(itemstack), player, player.field_71071_by.field_70461_c);
                }
            }
        }
        return itemstack;
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return 0.0f;
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
            ItemStack pb = this.getPickedBlock(stack);
            MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, (EntityPlayer)player, true);
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int x = mop.field_72311_b;
                int y = mop.field_72312_c;
                int z = mop.field_72309_d;
                if (pb != null && player.field_70170_p.func_147438_o(x, y, z) == null && player.field_70170_p.func_147439_a(x, y, z).func_149688_o() != Config.taintMaterial) {
                    ServerTickEventsFML.addSwapper(player.field_70170_p, x, y, z, player.field_70170_p.func_147439_a(x, y, z), player.field_70170_p.func_72805_g(x, y, z), pb, 0, (EntityPlayer)player, ((EntityPlayer)player).field_71071_by.field_70461_c);
                }
            }
        }
        return super.onEntitySwing(player, stack);
    }

    public void storePickedBlock(ItemStack stack, ItemStack stackout) {
        NBTTagCompound item = new NBTTagCompound();
        stack.func_77983_a("picked", (NBTBase)stackout.func_77955_b(item));
    }

    public ItemStack getPickedBlock(ItemStack stack) {
        ItemStack out = null;
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("picked")) {
            out = new ItemStack(Blocks.field_150350_a);
            out.func_77963_c(stack.field_77990_d.func_74775_l("picked"));
        }
        return out;
    }

    @Override
    public int getFocusColor() {
        return 8747923;
    }

    @Override
    public AspectList getVisCost() {
        return cost;
    }

    @Override
    public boolean acceptsEnchant(int id) {
        return id == ThaumcraftApi.enchantFrugal || id == ThaumcraftApi.enchantPotency || id == ThaumcraftApi.enchantWandFortune;
    }
}

