/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketSyncAspects
extends AbstractPacket {
    protected AspectList data;

    public PacketSyncAspects() {
    }

    public PacketSyncAspects(EntityPlayer player) {
        this.data = Thaumcraft.proxy.getPlayerKnowledge().getAspectsDiscovered(player.func_70005_c_());
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.data != null && this.data.size() > 0) {
            buffer.writeShort(this.data.size());
            for (Aspect a : this.data.getAspects()) {
                if (a == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)a.getTag());
                buffer.writeShort(this.data.getAmount(a));
            }
        } else {
            buffer.writeShort(0);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int size = buffer.readShort();
        this.data = new AspectList();
        for (int a = 0; a < size; ++a) {
            String tag = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            short amount = buffer.readShort();
            this.data.add(Aspect.getAspect(tag), amount);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        for (Aspect key : this.data.getAspects()) {
            Thaumcraft.proxy.getResearchManager().completeAspect(player, key, (short)this.data.getAmount(key));
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

