/*
 * Decompiled with CFR 0.152.
 */
package eplus.handlers;

import cpw.mods.fml.relauncher.ReflectionHelper;
import eplus.EnchantingPlus;
import eplus.lib.ConfigurationSettings;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;

public class ConfigurationHandler {
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_BOTH = "both";
    public static Configuration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File suggestedConfigurationFile) {
        configuration = new Configuration(suggestedConfigurationFile, false);
        EnchantingPlus.log.info("Initializing Configurations.");
        try {
            configuration.load();
            configuration.addCustomCategoryComment(CATEGORY_CLIENT, "Settings controlled client.\nCan vary from server to server.");
            configuration.addCustomCategoryComment(CATEGORY_SERVER, "Settings controlled by server.");
            configuration.addCustomCategoryComment(CATEGORY_BOTH, "Settings controlled by both.\nClient can be different from server.\nIf client differs from server, server can disable client's setting if false.");
            ConfigurationSettings.useMod = configuration.get(CATEGORY_BOTH, "useMod", true, "Set to true to use custom Enchantment Table in place of Vanilla").getBoolean(true);
            ConfigurationSettings.needsBookShelves = configuration.get(CATEGORY_SERVER, "needsBookShelves", true, "Set to true to require book shelves to enchant.").getBoolean(true);
            ConfigurationSettings.hasLight = configuration.get(CATEGORY_SERVER, "hasLight", true, "Set to true to have the enchanting table emmit light.").getBoolean(true);
            ConfigurationSettings.hasParticles = configuration.get(CATEGORY_CLIENT, "hasParticles", true, "Set to true to have the enchanting table emmit particles.").getBoolean(true);
            ConfigurationSettings.AllowDisenchanting = configuration.get(CATEGORY_SERVER, "AllowDisenchanting", true, "Set to true to allow disenchanting.").getBoolean(true);
            ConfigurationSettings.AllowRepair = configuration.get(CATEGORY_SERVER, "AllowRepair", ConfigurationSettings.repairDefault, "Set to true to allow repairing of items via enchantment table.").getBoolean(ConfigurationSettings.repairDefault);
        }
        catch (Exception e) {
            EnchantingPlus.log.info("Error Loading configuration");
            EnchantingPlus.log.log(Level.INFO, "Cause by {0}", e.getLocalizedMessage());
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void set(String propertyName, String newValue) {
        configuration.load();
        Set categoryNames = configuration.getCategoryNames();
        for (String category : categoryNames) {
            if (!configuration.getCategory(category).containsKey(propertyName)) continue;
            configuration.getCategory(category).get(propertyName).set(newValue);
        }
        Field field = ReflectionHelper.findField(ConfigurationSettings.class, (String[])new String[]{propertyName});
        try {
            if (field.getType() == Boolean.TYPE) {
                field.setBoolean(EnchantingPlus.INSTANCE, Boolean.parseBoolean(newValue));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }
}

