/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.util;

import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.util.StringUtil;
import com.sk89q.wepif.PermissionsResolverManager;
import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class DynamicPluginCommand
extends Command
implements PluginIdentifiableCommand {
    protected final CommandExecutor owner;
    protected final Object registeredWith;
    protected final Plugin owningPlugin;
    protected String[] permissions = new String[0];

    public DynamicPluginCommand(String[] aliases, String desc, String usage, CommandExecutor owner, Object registeredWith, Plugin plugin) {
        super(aliases[0], desc, usage, Arrays.asList(aliases));
        this.owner = owner;
        this.owningPlugin = plugin;
        this.registeredWith = registeredWith;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        return this.owner.onCommand(sender, (Command)this, label, args);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getRegisteredWith() {
        return this.registeredWith;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
        if (permissions != null) {
            super.setPermission(StringUtil.joinString(permissions, ";"));
        }
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public Plugin getPlugin() {
        return this.owningPlugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testPermissionSilent(CommandSender sender) {
        if (this.permissions == null) return true;
        if (this.permissions.length == 0) {
            return true;
        }
        if (this.registeredWith instanceof CommandsManager) {
            try {
                String[] stringArray = this.permissions;
                int n = this.permissions.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String permission = stringArray[n2];
                    if (((CommandsManager)this.registeredWith).hasPermission(sender, permission)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Throwable permission) {
                return super.testPermissionSilent(sender);
            }
        }
        if (!PermissionsResolverManager.isInitialized()) return super.testPermissionSilent(sender);
        if (!(sender instanceof OfflinePlayer)) return super.testPermissionSilent(sender);
        String[] stringArray = this.permissions;
        int n = this.permissions.length;
        int n3 = 0;
        while (n3 < n) {
            String permission = stringArray[n3];
            if (PermissionsResolverManager.getInstance().hasPermission((OfflinePlayer)sender, permission)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

