/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.util;

import com.sk89q.bukkit.util.DynamicPluginCommand;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.wepif.WEPIFRuntimeException;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicFactory;

public class DynamicPluginCommandHelpTopic
extends HelpTopic {
    private final DynamicPluginCommand cmd;

    public DynamicPluginCommandHelpTopic(DynamicPluginCommand cmd) {
        this.cmd = cmd;
        this.name = "/" + cmd.getName();
        String fullTextTemp = null;
        StringBuilder fullText = new StringBuilder();
        if (cmd.getRegisteredWith() instanceof CommandsManager) {
            String lookupName;
            Map<String, String> helpText = ((CommandsManager)cmd.getRegisteredWith()).getHelpMessages();
            if (helpText.containsKey(lookupName = cmd.getName().replaceAll("/", ""))) {
                fullTextTemp = helpText.get(lookupName);
            }
            if ((helpText = ((CommandsManager)cmd.getRegisteredWith()).getCommands()).containsKey(cmd.getName())) {
                String shortText = helpText.get(cmd.getName());
                if (fullTextTemp == null) {
                    fullTextTemp = String.valueOf(this.name) + " " + shortText;
                }
                this.shortText = shortText;
            }
        } else {
            this.shortText = cmd.getDescription();
        }
        String[] split = fullTextTemp == null ? new String[2] : fullTextTemp.split("\n", 2);
        fullText.append(ChatColor.BOLD).append(ChatColor.GOLD).append("Usage: ").append(ChatColor.WHITE);
        fullText.append(split[0]).append("\n");
        if (cmd.getAliases().size() > 0) {
            fullText.append(ChatColor.BOLD).append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE);
            boolean first = true;
            for (String alias : cmd.getAliases()) {
                if (!first) {
                    fullText.append(", ");
                }
                fullText.append(alias);
                first = false;
            }
            fullText.append("\n");
        }
        if (split.length > 1) {
            fullText.append(split[1]);
        }
        this.fullText = fullText.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean canSee(CommandSender player) {
        if (this.cmd.getPermissions() != null && this.cmd.getPermissions().length > 0) {
            String perm2;
            int n;
            int n2;
            String[] stringArray;
            if (this.cmd.getRegisteredWith() instanceof CommandsManager) {
                try {
                    stringArray = this.cmd.getPermissions();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        perm2 = stringArray[n];
                        if (((CommandsManager)this.cmd.getRegisteredWith()).hasPermission(player, perm2)) {
                            return true;
                        }
                        ++n;
                    }
                }
                catch (Throwable perm2) {
                    // empty catch block
                }
            }
            if (player instanceof OfflinePlayer) {
                try {
                    stringArray = this.cmd.getPermissions();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        perm2 = stringArray[n];
                        if (PermissionsResolverManager.getInstance().hasPermission((OfflinePlayer)player, perm2)) {
                            return true;
                        }
                        ++n;
                    }
                }
                catch (WEPIFRuntimeException perm3) {
                    // empty catch block
                }
            }
            stringArray = this.cmd.getPermissions();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                perm2 = stringArray[n];
                if (player.hasPermission(perm2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    public String getFullText(CommandSender forWho) {
        if (this.fullText == null || this.fullText.length() == 0) {
            return this.getShortText();
        }
        return this.fullText;
    }

    public static class Factory
    implements HelpTopicFactory<DynamicPluginCommand> {
        public HelpTopic createTopic(DynamicPluginCommand command) {
            return new DynamicPluginCommandHelpTopic(command);
        }
    }
}

