/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.wepif;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolver;
import org.anjocaido.groupmanager.dataholder.worlds.WorldsHolder;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class GroupManagerResolver
implements PermissionsResolver {
    private final WorldsHolder worldsHolder;
    private final Server server;

    public static PermissionsResolver factory(Server server, YAMLProcessor config) {
        try {
            WorldsHolder worldsHolder = (WorldsHolder)server.getServicesManager().load(WorldsHolder.class);
            if (worldsHolder == null) {
            }
            return new GroupManagerResolver(server, worldsHolder);
        }
        finally {
            return null;
        }
    }

    public GroupManagerResolver(Server server, WorldsHolder worldsHolder) {
        this.server = server;
        this.worldsHolder = worldsHolder;
    }

    @Override
    public void load() {
    }

    private AnjoPermissionsHandler getPermissionHandler(String name, String worldName) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (worldName == null || worldName.isEmpty()) {
            Player player = this.server.getPlayerExact(name);
            if (player == null) {
                return null;
            }
            World world = player.getWorld();
            if (world == null) {
                return this.worldsHolder.getDefaultWorld().getPermissionsHandler();
            }
            return this.worldsHolder.getWorldPermissions(world.getName());
        }
        return this.worldsHolder.getWorldPermissions(worldName);
    }

    @Override
    public boolean hasPermission(String name, String permission) {
        return this.hasPermission(null, name, permission);
    }

    @Override
    public boolean hasPermission(String worldName, String name, String permission) {
        if (permission == null || permission.isEmpty()) {
            return false;
        }
        AnjoPermissionsHandler permissionHandler = this.getPermissionHandler(name, worldName);
        if (permissionHandler == null) {
            return false;
        }
        return permissionHandler.permission(name, permission);
    }

    @Override
    public boolean inGroup(String name, String group) {
        if (group == null || group.isEmpty()) {
            return false;
        }
        AnjoPermissionsHandler permissionHandler = this.getPermissionHandler(name, null);
        if (permissionHandler == null) {
            return false;
        }
        return permissionHandler.inGroup(name, group);
    }

    @Override
    public String[] getGroups(String name) {
        AnjoPermissionsHandler permissionHandler = this.getPermissionHandler(name, null);
        if (permissionHandler == null) {
            return new String[0];
        }
        return permissionHandler.getGroups(name);
    }

    @Override
    public boolean hasPermission(OfflinePlayer player, String permission) {
        return this.hasPermission(player.getName(), permission);
    }

    @Override
    public boolean hasPermission(String worldName, OfflinePlayer player, String permission) {
        return this.hasPermission(worldName, player.getName(), permission);
    }

    @Override
    public boolean inGroup(OfflinePlayer player, String group) {
        return this.inGroup(player.getName(), group);
    }

    @Override
    public String[] getGroups(OfflinePlayer player) {
        return this.getGroups(player.getName());
    }

    @Override
    public String getDetectionMessage() {
        return "GroupManager detected! Using GroupManager for permissions.";
    }
}

