/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.cui.CUIEvent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitPlayer
extends LocalPlayer {
    private Player player;
    private WorldEditPlugin plugin;

    public BukkitPlayer(WorldEditPlugin plugin, ServerInterface server, Player player) {
        super(server);
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public int getItemInHand() {
        ItemStack itemStack = this.player.getItemInHand();
        return itemStack != null ? itemStack.getTypeId() : 0;
    }

    @Override
    public BaseBlock getBlockInHand() throws WorldEditException {
        ItemStack itemStack = this.player.getItemInHand();
        return BukkitUtil.toBlock(this.getWorld(), itemStack);
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public WorldVector getPosition() {
        Location loc = this.player.getLocation();
        return new WorldVector(BukkitUtil.getLocalWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public double getPitch() {
        return this.player.getLocation().getPitch();
    }

    @Override
    public double getYaw() {
        return this.player.getLocation().getYaw();
    }

    @Override
    public void giveItem(int type, int amt) {
        this.player.getInventory().addItem(new ItemStack[]{new ItemStack(type, amt)});
    }

    @Override
    public void printRaw(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.player.sendMessage(part);
            ++n2;
        }
    }

    @Override
    public void print(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.player.sendMessage("\u00a7d" + part);
            ++n2;
        }
    }

    @Override
    public void printDebug(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.player.sendMessage("\u00a77" + part);
            ++n2;
        }
    }

    @Override
    public void printError(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.player.sendMessage("\u00a7c" + part);
            ++n2;
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.teleport(new Location(this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ(), yaw, pitch));
    }

    @Override
    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    @Override
    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    @Override
    public LocalWorld getWorld() {
        return BukkitUtil.getLocalWorld(this.player.getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = String.valueOf(send) + "|" + StringUtil.joinString(params, "|");
        }
        this.player.sendPluginMessage((Plugin)this.plugin, "WECUI", send.getBytes(CUIChannelListener.UTF_8_CHARSET));
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean hasCreativeMode() {
        return this.player.getGameMode() == GameMode.CREATIVE;
    }

    @Override
    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        if (alwaysGlass || !this.player.getAllowFlight()) {
            super.floatAt(x, y, z, alwaysGlass);
            return;
        }
        this.setPosition(new Vector((double)x + 0.5, (double)y, (double)z + 0.5));
        this.player.setFlying(true);
    }
}

