/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.NmsBlock;
import com.sk89q.worldedit.data.DataException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.v1_7_R1.Block;
import net.minecraft.server.v1_7_R1.NBTBase;
import net.minecraft.server.v1_7_R1.NBTTagByte;
import net.minecraft.server.v1_7_R1.NBTTagByteArray;
import net.minecraft.server.v1_7_R1.NBTTagCompound;
import net.minecraft.server.v1_7_R1.NBTTagDouble;
import net.minecraft.server.v1_7_R1.NBTTagEnd;
import net.minecraft.server.v1_7_R1.NBTTagFloat;
import net.minecraft.server.v1_7_R1.NBTTagInt;
import net.minecraft.server.v1_7_R1.NBTTagIntArray;
import net.minecraft.server.v1_7_R1.NBTTagList;
import net.minecraft.server.v1_7_R1.NBTTagLong;
import net.minecraft.server.v1_7_R1.NBTTagShort;
import net.minecraft.server.v1_7_R1.NBTTagString;
import net.minecraft.server.v1_7_R1.TileEntity;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_7_R1.CraftWorld;

public class DefaultNmsBlock
extends NmsBlock {
    private static final Logger logger;
    private static Field compoundMapField;
    private static final Field nmsBlock_isTileEntityField;
    private NBTTagCompound nbtData = null;

    static {
        Field field;
        logger = WorldEdit.logger;
        try {
            field = Block.class.getDeclaredField("isTileEntity");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        nmsBlock_isTileEntityField = field;
    }

    public static boolean verify() {
        return nmsBlock_isTileEntityField != null;
    }

    public DefaultNmsBlock(int type, int data, TileEntityBlock tileEntityBlock) {
        super(type, data);
        this.nbtData = (NBTTagCompound)DefaultNmsBlock.fromNative(tileEntityBlock.getNbtData());
    }

    public DefaultNmsBlock(int type, int data, NBTTagCompound nbtData) {
        super(type, data);
        this.nbtData = nbtData;
    }

    private NBTTagCompound getNmsData(Vector pt) {
        if (this.nbtData == null) {
            return null;
        }
        this.nbtData.set("x", (NBTBase)new NBTTagInt(pt.getBlockX()));
        this.nbtData.set("y", (NBTBase)new NBTTagInt(pt.getBlockY()));
        this.nbtData.set("z", (NBTBase)new NBTTagInt(pt.getBlockZ()));
        return this.nbtData;
    }

    @Override
    public boolean hasNbtData() {
        return this.nbtData != null;
    }

    @Override
    public String getNbtId() {
        if (this.nbtData == null) {
            return "";
        }
        return this.nbtData.getString("id");
    }

    @Override
    public CompoundTag getNbtData() {
        if (this.nbtData == null) {
            return new CompoundTag(this.getNbtId(), new HashMap<String, Tag>());
        }
        return (CompoundTag)DefaultNmsBlock.toNative((NBTBase)this.nbtData);
    }

    @Override
    public void setNbtData(CompoundTag tag) throws DataException {
        if (tag == null) {
            this.nbtData = null;
        }
        this.nbtData = (NBTTagCompound)DefaultNmsBlock.fromNative(tag);
    }

    public static DefaultNmsBlock get(World world, Vector position, int type, int data) {
        if (!DefaultNmsBlock.hasTileEntity(type)) {
            return null;
        }
        TileEntity te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.b(tag);
            return new DefaultNmsBlock(type, data, tag);
        }
        return null;
    }

    public static boolean set(World world, Vector position, BaseBlock block) {
        TileEntity te;
        DefaultNmsBlock nmsProxyBlock;
        NBTTagCompound data = null;
        if (!DefaultNmsBlock.hasTileEntity(world.getBlockTypeIdAt(position.getBlockX(), position.getBlockY(), position.getBlockZ()))) {
            return false;
        }
        if (block instanceof DefaultNmsBlock) {
            nmsProxyBlock = (DefaultNmsBlock)block;
            data = nmsProxyBlock.getNmsData(position);
        } else if (block instanceof TileEntityBlock) {
            nmsProxyBlock = new DefaultNmsBlock(block.getId(), block.getData(), block);
            data = nmsProxyBlock.getNmsData(position);
        }
        if (data != null && (te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ())) != null) {
            te.a(data);
            return true;
        }
        return false;
    }

    public static boolean setSafely(BukkitWorld world, Vector position, com.sk89q.worldedit.foundation.Block block, boolean notifyAdjacent) {
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        CraftWorld craftWorld = (CraftWorld)world.getWorld();
        boolean changed = craftWorld.getHandle().setTypeAndData(x, y, z, DefaultNmsBlock.getNmsBlock(block.getId()), block.getData(), 0);
        if (block instanceof BaseBlock) {
            world.copyToWorld(position, (BaseBlock)block);
        }
        boolean bl = changed = craftWorld.getHandle().setData(x, y, z, block.getData(), 0) || changed;
        if (changed && notifyAdjacent) {
            craftWorld.getHandle().notify(x, y, z);
            craftWorld.getHandle().update(x, y, z, DefaultNmsBlock.getNmsBlock(block.getId()));
        }
        return changed;
    }

    public static boolean hasTileEntity(int type) {
        Block nmsBlock = DefaultNmsBlock.getNmsBlock(type);
        if (nmsBlock == null) {
            return false;
        }
        try {
            return nmsBlock_isTileEntityField.getBoolean(nmsBlock);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static Block getNmsBlock(int type) {
        return Block.e((int)type);
    }

    private static Tag toNative(NBTBase foreign) {
        return DefaultNmsBlock.toNative(NBTBase.getTagName((int)foreign.getTypeId()), foreign);
    }

    private static Tag toNative(String name, NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Set foreignKeys = null;
            if (compoundMapField == null) {
                try {
                    foreignKeys = ((NBTTagCompound)foreign).c();
                }
                catch (Throwable t) {
                    try {
                        logger.warning("WorldEdit: Couldn't get NBTTagCompound.c(), so we're going to try to get at the 'map' field directly from now on");
                        if (compoundMapField == null) {
                            compoundMapField = NBTTagCompound.class.getDeclaredField("map");
                            compoundMapField.setAccessible(true);
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (compoundMapField != null) {
                try {
                    foreignKeys = ((HashMap)compoundMapField.get(foreign)).keySet();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            for (Object obj : foreignKeys) {
                String key = (String)obj;
                NBTBase base = ((NBTTagCompound)foreign).get(key);
                values.put(key, DefaultNmsBlock.toNative(key, base));
            }
            return new CompoundTag(name, values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(name, ((NBTTagByte)foreign).f());
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(name, ((NBTTagByteArray)foreign).c());
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(name, ((NBTTagDouble)foreign).g());
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(name, ((NBTTagFloat)foreign).h());
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(name, ((NBTTagInt)foreign).d());
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(name, ((NBTTagIntArray)foreign).c());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return DefaultNmsBlock.transmorgifyList(name, (NBTTagList)foreign);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return new ListTag(name, ByteTag.class, new ArrayList());
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(name, ((NBTTagLong)foreign).c());
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(name, ((NBTTagShort)foreign).e());
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(name, ((NBTTagString)foreign).a_());
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private static ListTag transmorgifyList(String name, NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        int type = foreign.d();
        Field listField = NBTTagList.class.getDeclaredField("list");
        listField.setAccessible(true);
        List foreignList = (List)listField.get(foreign);
        int i = 0;
        while (i < foreign.size()) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(DefaultNmsBlock.toNative(null, element));
            ++i;
        }
        Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
        return new ListTag(name, cls, values);
    }

    private static NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), DefaultNmsBlock.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator iterator = foreignList.getValue().iterator();
            while (iterator.hasNext()) {
                Tag t = (Tag)iterator.next();
                tag.add(DefaultNmsBlock.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            try {
                Method tagMaker = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
                tagMaker.setAccessible(true);
                return (NBTBase)tagMaker.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    public static boolean isValidBlockType(int type) throws NoClassDefFoundError {
        return type == 0 || type >= 1 && Block.e((int)type) != null;
    }

    public static /* bridge */ /* synthetic */ NmsBlock get(World world, Vector vector, int n, int n2) {
        return DefaultNmsBlock.get(world, vector, n, n2);
    }
}

