/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.expression.runtime;

import com.sk89q.worldedit.expression.Expression;
import com.sk89q.worldedit.expression.parser.ParserException;
import com.sk89q.worldedit.expression.runtime.Constant;
import com.sk89q.worldedit.expression.runtime.EvaluationException;
import com.sk89q.worldedit.expression.runtime.Node;
import com.sk89q.worldedit.expression.runtime.RValue;
import java.util.ArrayList;

public class Sequence
extends Node {
    final RValue[] sequence;

    public Sequence(int position, RValue ... sequence) {
        super(position);
        this.sequence = sequence;
    }

    @Override
    public char id() {
        return 's';
    }

    @Override
    public double getValue() throws EvaluationException {
        double ret = 0.0;
        RValue[] rValueArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            RValue invokable = rValueArray[n2];
            ret = invokable.getValue();
            ++n2;
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("seq(");
        boolean first = true;
        RValue[] rValueArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            RValue invokable = rValueArray[n2];
            if (!first) {
                sb.append(", ");
            }
            sb.append(invokable);
            first = false;
            ++n2;
        }
        return sb.append(')').toString();
    }

    @Override
    public RValue optimize() throws EvaluationException {
        ArrayList<RValue> newSequence = new ArrayList<RValue>();
        RValue droppedLast = null;
        RValue[] rValueArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            RValue invokable = rValueArray[n2];
            droppedLast = null;
            if ((invokable = invokable.optimize()) instanceof Sequence) {
                RValue[] rValueArray2 = ((Sequence)invokable).sequence;
                int n3 = ((Sequence)invokable).sequence.length;
                int n4 = 0;
                while (n4 < n3) {
                    RValue subInvokable = rValueArray2[n4];
                    newSequence.add(subInvokable);
                    ++n4;
                }
            } else if (invokable instanceof Constant) {
                droppedLast = invokable;
            } else {
                newSequence.add(invokable);
            }
            ++n2;
        }
        if (droppedLast != null) {
            newSequence.add(droppedLast);
        }
        if (newSequence.size() == 1) {
            return (RValue)newSequence.get(0);
        }
        return new Sequence(this.getPosition(), newSequence.toArray(new RValue[newSequence.size()]));
    }

    @Override
    public RValue bindVariables(Expression expression, boolean preferLValue) throws ParserException {
        int i = 0;
        while (i < this.sequence.length) {
            this.sequence[i] = this.sequence[i].bindVariables(expression, false);
            ++i;
        }
        return this;
    }
}

