/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.filtering;

import java.awt.image.Kernel;

public class GaussianKernel
extends Kernel {
    public GaussianKernel(int radius, double sigma) {
        super(radius * 2 + 1, radius * 2 + 1, GaussianKernel.createKernel(radius, sigma));
    }

    private static float[] createKernel(int radius, double sigma) {
        int diameter = radius * 2 + 1;
        float[] data = new float[diameter * diameter];
        double sigma22 = 2.0 * sigma * sigma;
        double constant = Math.PI * sigma22;
        int y = -radius;
        while (y <= radius) {
            int x = -radius;
            while (x <= radius) {
                data[(y + radius) * diameter + x + radius] = (float)(Math.exp((double)(-(x * x + y * y)) / sigma22) / constant);
                ++x;
            }
            ++y;
        }
        return data;
    }
}

