/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIterator;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractRegion
implements Region {
    protected LocalWorld world;

    public AbstractRegion(LocalWorld world) {
        this.world = world;
    }

    @Override
    public Vector getCenter() {
        return this.getMinimumPoint().add(this.getMaximumPoint()).divide(2);
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new RegionIterator(this);
    }

    @Override
    public LocalWorld getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(LocalWorld world) {
        this.world = world;
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.expand(change);
        this.contract(change);
    }

    @Override
    public AbstractRegion clone() {
        try {
            return (AbstractRegion)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }

    @Override
    public List<BlockVector2D> polygonize(int maxPoints) {
        if (maxPoints >= 0 && maxPoints < 4) {
            throw new IllegalArgumentException("Cannot polygonize an AbstractRegion with no overridden polygonize method into less than 4 points.");
        }
        BlockVector min = this.getMinimumPoint().toBlockVector();
        BlockVector max = this.getMaximumPoint().toBlockVector();
        ArrayList<BlockVector2D> points = new ArrayList<BlockVector2D>(4);
        points.add(new BlockVector2D(min.getX(), min.getZ()));
        points.add(new BlockVector2D(min.getX(), max.getZ()));
        points.add(new BlockVector2D(max.getX(), max.getZ()));
        points.add(new BlockVector2D(max.getX(), min.getZ()));
        return points;
    }

    @Override
    public int getArea() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)((max.getX() - min.getX() + 1.0) * (max.getY() - min.getY() + 1.0) * (max.getZ() - min.getZ() + 1.0));
    }

    @Override
    public int getWidth() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getX() - min.getX() + 1.0);
    }

    @Override
    public int getHeight() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getY() - min.getY() + 1.0);
    }

    @Override
    public int getLength() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getZ() - min.getZ() + 1.0);
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        int minY = min.getBlockY();
        int x = min.getBlockX();
        while (x <= max.getBlockX()) {
            int z = min.getBlockZ();
            while (z <= max.getBlockZ()) {
                if (this.contains(new Vector(x, minY, z))) {
                    chunks.add(new BlockVector2D(x >> 4, z >> 4));
                }
                ++z;
            }
            ++x;
        }
        return chunks;
    }

    @Override
    public Set<Vector> getChunkCubes() {
        HashSet<Vector> chunks = new HashSet<Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        int x = min.getBlockX();
        while (x <= max.getBlockX()) {
            int y = min.getBlockY();
            while (y <= max.getBlockY()) {
                int z = min.getBlockZ();
                while (z <= max.getBlockZ()) {
                    if (this.contains(new Vector(x, y, z))) {
                        chunks.add(new BlockVector(x >> 4, y >> 4, z >> 4));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return chunks;
    }
}

