/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.lib;

import com.aesireanempire.eplus.handlers.ConfigurationHandler;
import com.aesireanempire.eplus.lib.ConfigurationSettings;
import com.aesireanempire.eplus.lib.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;

public class EnchantmentHelp {
    private static Map<String, String> toolTips = new HashMap<String, String>();
    private static List<String> enchantmentBlackList = new ArrayList<String>();
    private static List<Integer> itemBlackList = new ArrayList<Integer>();

    public static String getToolTip(Enchantment enchant) {
        return toolTips.containsKey(enchant.func_77320_a()) ? toolTips.get(enchant.func_77320_a()) : "";
    }

    public static void init() {
        EnchantmentHelp.putToolTips(Enchantment.field_77347_r, Strings.enchantmentUnbreaking);
        EnchantmentHelp.putToolTips(Enchantment.field_92091_k, Strings.enchantmentThorns);
        EnchantmentHelp.putToolTips(Enchantment.field_77341_i, Strings.enchantmentAquaAffinity);
        EnchantmentHelp.putToolTips(Enchantment.field_77340_h, Strings.enchantmentRespiration);
        EnchantmentHelp.putToolTips(Enchantment.field_77328_g, Strings.enchantmentProtectionProjectile);
        EnchantmentHelp.putToolTips(Enchantment.field_77327_f, Strings.enchantmentProtectionBlast);
        EnchantmentHelp.putToolTips(Enchantment.field_77330_e, Strings.enchantmentFeatherFalling);
        EnchantmentHelp.putToolTips(Enchantment.field_77329_d, Strings.enchantmentProtectionFire);
        EnchantmentHelp.putToolTips(Enchantment.field_77332_c, Strings.enchantmentProtection);
        EnchantmentHelp.putToolTips(Enchantment.field_77338_j, Strings.enchantmentSharpness);
        EnchantmentHelp.putToolTips(Enchantment.field_77339_k, Strings.enchantmentSmite);
        EnchantmentHelp.putToolTips(Enchantment.field_77336_l, Strings.enchantmentBaneOfAthropods);
        EnchantmentHelp.putToolTips(Enchantment.field_77337_m, Strings.enchantmentKnockBack);
        EnchantmentHelp.putToolTips(Enchantment.field_77334_n, Strings.enchantmentFireAspect);
        EnchantmentHelp.putToolTips(Enchantment.field_77335_o, Strings.enchantmentLooting);
        EnchantmentHelp.putToolTips(Enchantment.field_77349_p, Strings.enchantmentEfficiency);
        EnchantmentHelp.putToolTips(Enchantment.field_77348_q, Strings.enchantmentSilkTouch);
        EnchantmentHelp.putToolTips(Enchantment.field_77346_s, Strings.enchantmentFortune);
        EnchantmentHelp.putToolTips(Enchantment.field_77345_t, Strings.enchantmentPower);
        EnchantmentHelp.putToolTips(Enchantment.field_77344_u, Strings.enchantmentPunch);
        EnchantmentHelp.putToolTips(Enchantment.field_77343_v, Strings.enchantmentFlame);
        EnchantmentHelp.putToolTips(Enchantment.field_77342_w, Strings.enchantmentInfinity);
        EnchantmentHelp.saveToolTips();
    }

    public static void saveToolTips() {
        for (String enchantment : toolTips.keySet()) {
            ConfigurationHandler.set(enchantment + "-ToolTip", toolTips.get(enchantment));
        }
    }

    public static boolean isBlackListed(Enchantment enchantment) {
        boolean flag;
        boolean bl = flag = enchantment != null && enchantmentBlackList.contains(enchantment.func_77320_a());
        if (ConfigurationSettings.enchantments.containsKey(enchantment.func_77320_a())) {
            flag |= ConfigurationSettings.enchantments.get(enchantment.func_77320_a()) == false;
        }
        return !flag;
    }

    public static boolean isBlackListed(Item item) {
        return itemBlackList.contains(Item.func_150891_b((Item)item));
    }

    public static boolean putBlackList(String string) {
        if (!enchantmentBlackList.contains(string)) {
            enchantmentBlackList.add(string);
            return true;
        }
        return false;
    }

    public static boolean putBlackListItem(Integer itemId) {
        if (!itemBlackList.contains(itemId)) {
            itemBlackList.add(itemId);
            return true;
        }
        return false;
    }

    public static boolean putToolTips(Enchantment enchantment, String info) {
        return EnchantmentHelp.putToolTips(enchantment.func_77320_a(), info);
    }

    public static boolean putToolTips(String enchantment, String info) {
        if (!toolTips.containsKey(enchantment)) {
            toolTips.put(enchantment, info);
            return true;
        }
        if (toolTips.get(enchantment).isEmpty()) {
            toolTips.put(enchantment, info);
            return true;
        }
        return false;
    }

    public static void putBlackListItem(List<Integer> itemsBlackList) {
        for (Integer itemId : itemsBlackList) {
            EnchantmentHelp.putBlackListItem(itemId);
        }
    }
}

